/*
 * Decompiled with CFR 0.152.
 */
package de.miethxml.toolkit.auth.ui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.miethxml.toolkit.auth.AuthenticationReceiver;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class LoginUI {
    private JTextField username;
    private JPasswordField password;
    private JPanel view;
    private AuthenticationReceiver receiver;
    private String text = "Login";

    public LoginUI(AuthenticationReceiver receiver) {
        this.receiver = receiver;
    }

    public LoginUI(AuthenticationReceiver receiver, String title) {
        this.receiver = receiver;
        this.text = title;
    }

    public JComponent getView() {
        if (this.view == null) {
            this.init();
        }
        return this.view;
    }

    private void init() {
        this.view = new JPanel(){
            Color start = Color.GRAY;
            Color end = Color.WHITE;

            protected void paintComponent(Graphics g) {
                Graphics2D g2 = (Graphics2D)g;
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                int width = this.getWidth();
                int height = this.getHeight();
                GradientPaint gradient = new GradientPaint(0.0f, height, this.start, (int)((double)width * 0.5), height * 0, this.end);
                g2.setPaint(gradient);
                g2.fillRect(0, 0, width, height);
            }
        };
        FormLayout layout = new FormLayout("fill:10dlu:grow,fill:10dlu:grow", "fill:10dlu:grow,fill:10dlu:grow");
        CellConstraints cc = new CellConstraints();
        this.view.setLayout((LayoutManager)layout);
        JComponent title = new JComponent(){
            Color textColor = new Color(255, 160, 0);

            protected void paintComponent(Graphics g) {
                Graphics2D g2 = (Graphics2D)g;
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setFont(this.getFont());
                g2.setColor(this.textColor);
                g2.drawString(LoginUI.this.text, 0, g2.getFontMetrics().getHeight());
            }

            public Dimension getPreferredSize() {
                FontMetrics fm = this.getFontMetrics(this.getFont());
                return new Dimension(fm.stringWidth(LoginUI.this.text), fm.getHeight() + fm.getDescent());
            }
        };
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        FormLayout l = new FormLayout("fill:3dlu:grow,right:pref,1dlu", "fill:3dlu:grow,pref,2dlu,p,1dlu");
        CellConstraints subcc = new CellConstraints();
        panel.setLayout((LayoutManager)l);
        title.setFont(new Font("Serif", 1, 56));
        panel.add((Component)title, subcc.xy(2, 2));
        JLabel label = new JLabel("Username:");
        panel.add((Component)label, subcc.xy(2, 4));
        this.view.add((Component)panel, cc.xy(1, 1));
        panel = new JPanel();
        panel.setOpaque(false);
        l = new FormLayout("1dlu,left:pref,fill:3dlu:grow", "fill:3dlu:grow,pref,1dlu");
        subcc = new CellConstraints();
        panel.setLayout((LayoutManager)l);
        this.username = new JTextField(10);
        this.username.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LoginUI.this.username.transferFocus();
            }
        });
        this.username.setBorder(BorderFactory.createLineBorder(Color.DARK_GRAY));
        panel.add((Component)this.username, subcc.xy(2, 2));
        this.view.add((Component)panel, cc.xy(2, 1));
        panel = new JPanel();
        panel.setOpaque(false);
        l = new FormLayout("fill:3dlu:grow,right:pref,1dlu", "1dlu,pref,fill:3dlu:grow");
        subcc = new CellConstraints();
        panel.setLayout((LayoutManager)l);
        label = new JLabel("Password:");
        panel.add((Component)label, subcc.xy(2, 2));
        this.view.add((Component)panel, cc.xy(1, 2));
        ActionListener action = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(this){
                    final /* synthetic */ 4 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        LoginUI.access$2(4.access$0(this.this$1));
                    }
                });
            }

            static /* synthetic */ LoginUI access$0(4 var0) {
                return var0.LoginUI.this;
            }
        };
        panel = new JPanel();
        panel.setOpaque(false);
        l = new FormLayout("1dlu,left:pref,fill:3dlu:grow", "1dlu,pref,3dlu,pref,fill:3dlu:grow");
        subcc = new CellConstraints();
        panel.setLayout((LayoutManager)l);
        this.password = new JPasswordField(10);
        this.password.addActionListener(action);
        this.password.setBorder(BorderFactory.createLineBorder(Color.DARK_GRAY));
        panel.add((Component)this.password, subcc.xy(2, 2));
        JButton button = new JButton("Login");
        button.addActionListener(action);
        panel.add((Component)button, subcc.xy(2, 4));
        this.view.add((Component)panel, cc.xy(2, 2));
    }

    private void doLogin() {
        if (!this.receiver.accept(this.username.getText(), this.password.getPassword())) {
            this.username.setText("");
            this.password.setText("");
        }
    }

    static /* synthetic */ void access$2(LoginUI loginUI) {
        loginUI.doLogin();
    }
}

