/*
 * Decompiled with CFR 0.152.
 */
package de.miethxml.toolkit.classloader;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Iterator;

public class PluginClassLoader
extends URLClassLoader {
    private ClassLoader parent;
    private ArrayList nativeLibraryPath = new ArrayList();

    public PluginClassLoader() {
        super(new URL[0]);
        this.parent = this.getClass().getClassLoader();
    }

    public PluginClassLoader(ClassLoader parent) {
        this();
        this.parent = parent;
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    public Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (name.startsWith("java.") || name.startsWith("javax.swing.")) {
            return this.parent.loadClass(name);
        }
        Class<?> clazz = this.findLoadedClass(name);
        if (clazz == null) {
            try {
                clazz = super.findClass(name);
            }
            catch (Exception e) {
                return this.parent.loadClass(name);
            }
            catch (Error er) {
                return this.parent.loadClass(name);
            }
        }
        if (resolve) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    public void addJarLibrary(String lib) {
        File libfile = new File(lib);
        if (libfile.isFile()) {
            try {
                URL url = libfile.toURI().toURL();
                super.addURL(url);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
    }

    public void addJarDirectory(String dir) {
        File libDir = new File(dir);
        if (libDir.isDirectory()) {
            File[] files = libDir.listFiles();
            int i = 0;
            while (i < files.length) {
                if (files[i].getName().endsWith(".jar") || files[i].getName().endsWith(".zip")) {
                    try {
                        URL url = files[i].toURI().toURL();
                        super.addURL(url);
                    }
                    catch (MalformedURLException e) {
                        e.printStackTrace();
                    }
                }
                ++i;
            }
        }
    }

    public void addResourceDirectory(String dir) {
        File libDir = new File(dir);
        if (libDir.isDirectory()) {
            try {
                URL url = libDir.toURI().toURL();
                super.addURL(url);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
    }

    public void addResource(String resource) {
        File lib = new File(resource);
        if (lib.exists()) {
            try {
                URL url = lib.toURI().toURL();
                super.addURL(url);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
    }

    public String findLibrary(String name) {
        String libname = System.mapLibraryName(name);
        Iterator i = this.nativeLibraryPath.iterator();
        while (i.hasNext()) {
            String path = (String)i.next();
            File f = new File(String.valueOf(path) + File.separator + libname);
            if (!f.exists() || !f.isFile()) continue;
            return f.getAbsolutePath();
        }
        return super.findLibrary(name);
    }

    public void addNativeLibraryPath(String path) {
        File p = new File(path);
        if (p.exists() && p.isDirectory()) {
            this.nativeLibraryPath.add(p.getAbsolutePath());
        }
    }

    public synchronized void addClassDirectory(String path) {
        File libDir = new File(path);
        if (libDir.isDirectory()) {
            try {
                URL url = libDir.toURI().toURL();
                super.addURL(url);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
    }

    public synchronized void addPathElement(String path) {
        File f = new File(path);
        if (f.isFile()) {
            this.addJarLibrary(path);
            return;
        }
        if (f.isDirectory()) {
            this.addClassDirectory(path);
            this.addJarDirectory(path);
        }
    }
}

