/*
 * Decompiled with CFR 0.152.
 */
package de.miethxml.toolkit.container;

import de.miethxml.toolkit.application.ApplicationShutdown;
import de.miethxml.toolkit.application.CLIParser;
import de.miethxml.toolkit.application.Launcher;
import de.miethxml.toolkit.component.GuiConfigurable;
import de.miethxml.toolkit.component.PluginComponent;
import de.miethxml.toolkit.conf.LocaleImpl;
import de.miethxml.toolkit.conf.StoreableConfigurationImpl;
import de.miethxml.toolkit.gui.SplashScreen;
import de.miethxml.toolkit.plugins.PluginManager;
import de.miethxml.toolkit.plugins.PluginManagerImpl;
import de.miethxml.toolkit.plugins.PluginReceiver;
import de.miethxml.toolkit.setup.ApplicationSetup;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.avalon.framework.container.ContainerUtil;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.DefaultContext;
import org.apache.avalon.framework.logger.LogKitLogger;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.DefaultServiceManager;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.log.Hierarchy;
import org.apache.log.LogTarget;
import org.apache.log.Logger;
import org.apache.log.format.Formatter;
import org.apache.log.format.PatternFormatter;
import org.apache.log.output.io.FileTarget;
import org.xml.sax.SAXException;

public class DefaultApplicationContainer
implements PluginReceiver,
ApplicationShutdown,
Launcher {
    public static String XCONF_FILE = "conf/application.xconf";
    protected Logger log;
    protected DefaultServiceManager manager = new DefaultServiceManager();
    protected PluginManager pluginManager;
    protected ApplicationSetup appSetup = new ApplicationSetup();
    protected Configuration config;
    protected LogKitLogger appLogger;
    protected Hashtable launchParameters;
    protected ArrayList components = new ArrayList();
    protected HashSet pluginRoles = new HashSet();
    protected Hashtable componentobjects = new Hashtable();
    protected Hashtable roles = new Hashtable();
    protected DefaultContext context;
    protected StoreableConfigurationImpl appConfig;
    protected Parameters params;
    protected Collection pluginInterfaces;
    protected boolean logEnabled = false;
    protected boolean contextEnabled = false;
    protected boolean serviceEnabled = false;
    protected boolean configureEnabled = false;
    protected boolean parameterEnabled = false;
    protected boolean initializeEnabed = false;
    protected boolean startEnabled = false;
    protected boolean guiconfigured = false;
    protected SplashScreen splash;
    protected Hierarchy h;
    private boolean stoptEnabled;

    public void initializeApplication() {
        try {
            this.h = new Hierarchy();
            this.h.setDefaultLogTarget((LogTarget)new FileTarget(new File("debug.log"), false, (Formatter)new PatternFormatter("%{time:HH:mm:ss.SSS dd.MM.y} [%{priority}]  %{category}: %{context} %{message}\n")));
            this.log = this.h.getLoggerFor(this.getClass().getName());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        LocaleImpl.getInstance();
        DefaultConfigurationBuilder builder = new DefaultConfigurationBuilder();
        try {
            this.config = builder.buildFromFile(XCONF_FILE);
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.splash.nextSubStep();
        this.loadComponent();
        PluginManagerImpl pm = new PluginManagerImpl();
        pm.setLogger(this.h.getLoggerFor(PluginManager.ROLE));
        this.pluginManager = pm;
        this.pluginInterfaces = new HashSet();
        this.pluginInterfaces.add("ALL PLUGINS");
        this.manager.put(PluginManager.ROLE, (Object)this.pluginManager);
        this.pluginManager.addPluginReceiver(this);
        this.manager.put(ApplicationShutdown.ROLE, (Object)this);
        this.pluginManager.findPlugins("plugins");
        this.splash.next("Initialize ...");
        this.splash.startSubSteps(this.components.size() + 6);
        this.manager.put(ApplicationSetup.ROLE, (Object)this.appSetup);
        this.enableLoggingComponents();
        this.splash.nextSubStep();
        this.handleApplicationLifecycle();
        this.contextualizeComponents();
        this.splash.nextSubStep();
        this.serviceComponents();
        this.splash.nextSubStep();
        this.configureComponents();
        this.splash.nextSubStep();
        this.parameterizeComponents();
        this.splash.nextSubStep();
        this.initializeComponents();
        this.guiConfigure();
        this.splash.endSubSteps();
    }

    public void lauchApplication() {
        this.startComponents();
    }

    protected void loadComponent() {
        try {
            String role;
            Object object;
            Class<?> clazz;
            Configuration[] configs = this.config.getChild("role-list").getChildren();
            int i = 0;
            while (i < configs.length) {
                if (configs[i].getName().equals("role")) {
                    this.roles.put(configs[i].getAttribute("default-class"), configs[i].getAttribute("name"));
                }
                ++i;
            }
            configs = this.config.getChild("components").getChildren();
            i = 0;
            while (i < configs.length) {
                if (configs[i].getName().equals("component")) {
                    String instanceClass = configs[i].getAttribute("class");
                    clazz = this.getClass().getClassLoader().loadClass(instanceClass);
                    object = clazz.newInstance();
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("load component:" + instanceClass);
                    }
                    this.components.add(object);
                    this.componentobjects.put(instanceClass, object);
                    if (this.roles.containsKey(instanceClass)) {
                        role = (String)this.roles.get(instanceClass);
                        this.manager.put(role, object);
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("add to service manager:" + instanceClass + " for role:" + role);
                        }
                        this.roles.remove(instanceClass);
                    }
                }
                ++i;
            }
            if (this.roles.size() > 0) {
                Enumeration e = this.roles.keys();
                while (e.hasMoreElements()) {
                    String classname = (String)e.nextElement();
                    clazz = this.getClass().getClassLoader().loadClass(classname);
                    object = clazz.newInstance();
                    role = (String)this.roles.get(classname);
                    this.manager.put(role, object);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("add to servicemanager:" + classname + " with role:" + role);
                    }
                    this.components.add(object);
                }
            }
        }
        catch (Exception e1) {
            this.log.error(e1.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeComponents() {
        ArrayList arrayList = this.components;
        synchronized (arrayList) {
            Iterator i = this.components.iterator();
            while (i.hasNext()) {
                Object object = i.next();
                try {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("try to initialize: " + object.getClass().getName());
                    }
                    this.splash.nextSubStep();
                    ContainerUtil.initialize(object);
                }
                catch (Exception e) {
                    this.log.error("initialize: " + object.getClass().getName() + " " + e.getMessage(), (Throwable)e);
                }
            }
        }
        this.initializeEnabed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposeComponents() {
        ArrayList arrayList = this.components;
        synchronized (arrayList) {
            Iterator i = this.components.iterator();
            while (i.hasNext()) {
                Object object = i.next();
                try {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("try to dispose: " + object.getClass().getName());
                    }
                    ContainerUtil.dispose(object);
                }
                catch (Exception e) {
                    this.log.error("dispose: " + object.getClass().getName() + " " + e.getMessage());
                }
            }
        }
        Hierarchy.getDefaultHierarchy().getRootLogger().unsetLogTargets();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void serviceComponents() {
        ArrayList arrayList = this.components;
        synchronized (arrayList) {
            Iterator i = this.components.iterator();
            while (i.hasNext()) {
                Object object = i.next();
                try {
                    this.log.debug("try to service " + object.getClass().getName());
                    ContainerUtil.service(object, (ServiceManager)this.manager);
                }
                catch (Exception e) {
                    this.log.error("service: " + object.getClass().getName() + " " + e.getMessage());
                }
            }
        }
        this.serviceEnabled = true;
    }

    public void init() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startComponents() {
        ArrayList arrayList = this.components;
        synchronized (arrayList) {
            Iterator i = this.components.iterator();
            while (i.hasNext()) {
                Object object = i.next();
                try {
                    this.log.debug("try to start " + object.getClass().getName());
                    ContainerUtil.start(object);
                }
                catch (Exception e) {
                    this.log.error("start: " + object.getClass().getName() + " " + e.getMessage());
                }
            }
        }
        this.startEnabled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopComponents() {
        ArrayList arrayList = this.components;
        synchronized (arrayList) {
            Iterator i = this.components.iterator();
            while (i.hasNext()) {
                Object object = i.next();
                try {
                    this.log.debug("try to stop " + object.getClass().getName());
                    ContainerUtil.stop(object);
                }
                catch (Exception e) {
                    this.log.error("stop: " + object.getClass().getName() + " " + e.getMessage());
                }
            }
        }
        this.stoptEnabled = true;
    }

    protected void processPluginObject(Object plugin) {
        if (!this.logEnabled) {
            return;
        }
        ContainerUtil.enableLogging((Object)plugin, (org.apache.avalon.framework.logger.Logger)this.appLogger);
        if (this.contextEnabled) {
            try {
                ContainerUtil.contextualize((Object)plugin, (Context)this.context);
            }
            catch (ContextException e) {
                e.printStackTrace();
            }
        } else {
            return;
        }
        if (this.serviceEnabled) {
            try {
                ContainerUtil.service((Object)plugin, (ServiceManager)this.manager);
            }
            catch (ServiceException e) {
                this.log.error("plugin serviceable exception: " + e.getMessage());
                e.printStackTrace();
            }
        } else {
            return;
        }
        if (this.configureEnabled) {
            try {
                ContainerUtil.configure((Object)plugin, (Configuration)this.config);
            }
            catch (ConfigurationException e) {
                e.printStackTrace();
            }
        } else {
            return;
        }
        if (this.parameterEnabled) {
            try {
                ContainerUtil.parameterize((Object)plugin, (Parameters)this.params);
            }
            catch (ParameterException e) {
                e.printStackTrace();
            }
        } else {
            return;
        }
        if (this.initializeEnabed) {
            try {
                ContainerUtil.initialize((Object)plugin);
            }
            catch (Exception e) {
                this.log.error("plugin initialize exception: " + e.getMessage());
                e.printStackTrace();
            }
        } else {
            return;
        }
        if (this.startEnabled) {
            try {
                ContainerUtil.start((Object)plugin);
            }
            catch (Exception e) {
                this.log.error("plugin startable exception: " + e.getMessage());
                e.printStackTrace();
            }
        } else {
            return;
        }
        if (this.guiconfigured && plugin instanceof GuiConfigurable) {
            this.appSetup.addGuiConfigurable("setup.components", (GuiConfigurable)plugin);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void guiConfigure() {
        ArrayList arrayList = this.components;
        synchronized (arrayList) {
            Iterator i = this.components.iterator();
            while (i.hasNext()) {
                Object object = i.next();
                if (!(object instanceof GuiConfigurable)) continue;
                this.appSetup.addGuiConfigurable("setup", (GuiConfigurable)object);
            }
        }
        this.guiconfigured = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enableLoggingComponents() {
        ArrayList arrayList = this.components;
        synchronized (arrayList) {
            Iterator i = this.components.iterator();
            while (i.hasNext()) {
                Object object = i.next();
                try {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("try to enableLogger: " + object.getClass().getName());
                    }
                    ContainerUtil.enableLogging(object, (org.apache.avalon.framework.logger.Logger)new LogKitLogger(this.h.getLoggerFor(object.getClass().getName())));
                }
                catch (Exception e) {
                    this.log.error("enableLogger: " + object.getClass().getName() + " " + e.getMessage());
                }
            }
        }
        this.logEnabled = true;
    }

    public void setLaunchParameters(Hashtable launchParameters) {
        this.launchParameters = launchParameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void contextualizeComponents() {
        this.context = new DefaultContext();
        String home = new File("").getAbsolutePath();
        this.log.debug("app-home=" + home);
        ArrayList arrayList = this.components;
        synchronized (arrayList) {
            Iterator i = this.components.iterator();
            while (i.hasNext()) {
                Object object = i.next();
                try {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("try contextualize: " + object.getClass().getName());
                    }
                    ContainerUtil.contextualize(object, (Context)this.context);
                }
                catch (Exception ex) {
                    this.log.error("contextualize: " + object.getClass().getName() + " " + ex.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parameterizeComponents() {
        this.params = new Parameters();
        Enumeration e = this.launchParameters.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            System.out.println("key=" + key + " value=" + this.launchParameters.get(key));
            this.params.setParameter(key, (String)this.launchParameters.get(key));
        }
        ArrayList arrayList = this.components;
        synchronized (arrayList) {
            Iterator i = this.components.iterator();
            while (i.hasNext()) {
                Object object = i.next();
                try {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("try parameterize: " + object.getClass().getName());
                    }
                    ContainerUtil.parameterize(object, (Parameters)this.params);
                }
                catch (Exception ex) {
                    this.log.error("parameterize: " + object.getClass().getName() + " " + ex.getMessage());
                }
            }
        }
        this.parameterEnabled = true;
    }

    protected void configureComponents() {
        Configuration[] configs = this.config.getChild("components").getChildren();
        int i = 0;
        while (i < configs.length) {
            String clazz = null;
            if (configs[i].getName().equals("component")) {
                try {
                    clazz = configs[i].getAttribute("class");
                    if (this.componentobjects.containsKey(clazz)) {
                        ContainerUtil.configure(this.componentobjects.get(clazz), (Configuration)configs[i]);
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("try configure: " + clazz);
                        }
                    }
                }
                catch (ConfigurationException e) {
                    this.log.error("configure:" + clazz + " " + e.getMessage());
                    e.printStackTrace();
                }
            }
            ++i;
        }
        this.configureEnabled = true;
    }

    public void addPlugin(Object plugin) {
        if (plugin instanceof PluginComponent) {
            PluginComponent component = (PluginComponent)plugin;
            this.manager.put(component.getRole(), plugin);
            this.pluginRoles.add(component.getRole());
        }
        this.processPluginObject(plugin);
        this.components.add(plugin);
    }

    public Collection getInterfaces() {
        return this.pluginInterfaces;
    }

    public void removePlugin(Object obj) {
    }

    public void shutdownApplication() {
        this.stopComponents();
        this.storeConfiguration();
        this.disposeComponents();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Shutdown Application");
        }
        System.exit(0);
    }

    public void init(Hashtable param) {
        this.splash = new SplashScreen("icons/splash.jpg", "Start ;-)");
        this.splash.setMaximum(3);
        this.splash.setVisible(true);
        this.splash.next("Loading ...");
        if (System.getProperty("os.name").indexOf("indows") > -1) {
            try {
                PrintStream ps = new PrintStream(new BufferedOutputStream(new FileOutputStream("jre.log", false), 128));
                System.setErr(ps);
                System.setOut(ps);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        this.setLaunchParameters(param);
        this.initializeApplication();
        this.splash.next("Launching ...");
        this.startComponents();
        this.splash.dispose();
        this.splash = null;
    }

    public void setProperty(String key, String value) {
    }

    public static void main(String[] args) {
        DefaultApplicationContainer container = new DefaultApplicationContainer();
        container.init(CLIParser.parseParameters((String[])args));
    }

    protected void storeConfiguration() {
    }

    protected void handleApplicationLifecycle() {
    }
}

