/*
 * Decompiled with CFR 0.152.
 */
package de.miethxml.toolkit.gui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.miethxml.toolkit.gui.LocaleSeparator;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Hashtable;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;

public class ButtonPanel
extends JPanel {
    private Hashtable actions;
    private JPanel toolbar;
    private String localeKey;
    private LocaleSeparator separator;
    private int buttonSize = 28;
    private int hgap = 2;
    private int vgap = 2;

    public ButtonPanel() {
        this.actions = new Hashtable();
    }

    public ButtonPanel(boolean isDoubleBuffered) {
        super(isDoubleBuffered);
    }

    public ButtonPanel(LayoutManager layout) {
        super(layout);
    }

    public ButtonPanel(LayoutManager layout, boolean isDoubleBuffered) {
        super(layout, isDoubleBuffered);
    }

    public ButtonPanel(String localeKey) {
        this();
        this.localeKey = localeKey;
    }

    public void init() {
        FormLayout layout = new FormLayout("3dlu,fill:pref:grow,3dlu", "3dlu,p,2dlu,top:p:grow,3dlu");
        this.setLayout((LayoutManager)layout);
        CellConstraints cc = new CellConstraints();
        LocaleSeparator separator = new LocaleSeparator(this.localeKey);
        this.add((Component)separator, cc.xy(2, 2));
        this.toolbar = new JPanel(new FlowLayout(0, this.hgap, this.vgap));
        this.toolbar.setBorder(BorderFactory.createEmptyBorder());
        this.add((Component)this.toolbar, cc.xy(2, 4));
        this.setVisible(false);
    }

    public void addAction(Action action) {
        if (!this.isVisible()) {
            this.setVisible(true);
        }
        JButton button = new JButton(action);
        button.setText("");
        button.setPreferredSize(new Dimension(this.buttonSize, this.buttonSize));
        button.setMargin(new Insets(0, 0, 0, 0));
        this.toolbar.add(button);
        this.actions.put(action, button);
        this.layoutToolBar();
    }

    public void removeAction(Action action) {
        if (this.actions.containsKey(action)) {
            JButton button = (JButton)this.actions.remove(action);
            this.toolbar.remove(button);
            if (this.actions.size() == 0) {
                this.setVisible(false);
            }
            this.layoutToolBar();
        }
    }

    public void setButtonSize(int size) {
    }

    private void layoutToolBar() {
        int height = (int)(Math.floor((double)((this.buttonSize + this.hgap) * this.actions.size()) / this.getPreferredSize().getWidth()) * (double)(this.buttonSize + this.vgap) + (double)this.vgap);
        if (height > this.buttonSize + this.vgap) {
            this.toolbar.setPreferredSize(new Dimension((int)this.getPreferredSize().getWidth(), height));
        } else {
            this.toolbar.setPreferredSize(new Dimension((int)this.getPreferredSize().getWidth(), this.buttonSize + this.vgap));
        }
        this.validate();
        this.toolbar.validate();
        this.repaint();
    }
}

