/*
 * Decompiled with CFR 0.152.
 */
package de.miethxml.toolkit.gui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.miethxml.toolkit.gui.LocaleButton;
import de.miethxml.toolkit.gui.LocaleLabel;
import de.miethxml.toolkit.gui.StringListView;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class StringListViewImpl
extends JPanel
implements StringListView,
ActionListener {
    private StringListModel model = new StringListModel();
    private JTextField input;
    private JLabel title;
    private JList list;

    public void setStringList(List list) {
        this.model.setStringList(list);
    }

    public List getStringList() {
        return this.model.getStringList();
    }

    public void init() {
        FormLayout layout = new FormLayout("right:pref,3dlu,60dlu:grow,3dlu,pref", "p,2dlu,p,2dlu,p:grow,2dlu,p");
        CellConstraints cc = new CellConstraints();
        this.setLayout((LayoutManager)layout);
        this.title = new JLabel("");
        this.add((Component)this.title, cc.xy(1, 1));
        this.list = new JList(this.model);
        JScrollPane sp = new JScrollPane(this.list);
        this.add((Component)sp, cc.xywh(3, 1, 1, 5));
        LocaleButton button = new LocaleButton("view.stringlist.button.add");
        button.setActionCommand("add");
        button.addActionListener(this);
        this.add((Component)button, cc.xy(5, 1));
        button = new LocaleButton("view.stringlist.button.remove");
        button.setActionCommand("remove");
        button.addActionListener(this);
        this.add((Component)button, cc.xy(5, 3));
        LocaleLabel label = new LocaleLabel("view.stringlist.label.edit");
        this.add((Component)label, cc.xy(1, 7));
        this.input = new JTextField(20);
        this.input.setActionCommand("add");
        this.input.addActionListener(this);
        this.add((Component)this.input, cc.xy(3, 7));
    }

    public void actionPerformed(ActionEvent e) {
        int index;
        if (e.getActionCommand().equals("add")) {
            if (this.input.getText().length() > 0) {
                this.model.add(this.input.getText().trim());
                this.input.setText("");
            }
        } else if (e.getActionCommand().equals("remove") && (index = this.list.getSelectedIndex()) > -1 && index < this.model.getSize()) {
            this.input.setText(this.model.remove(index));
        }
    }

    public JPanel getView() {
        return this;
    }

    private class StringListModel
    implements ListModel {
        private ArrayList listener = new ArrayList();
        private List stringList = new ArrayList();

        public void addListDataListener(ListDataListener arg0) {
            this.listener.add(arg0);
        }

        public Object getElementAt(int arg0) {
            return this.stringList.get(arg0);
        }

        public int getSize() {
            return this.stringList.size();
        }

        public void removeListDataListener(ListDataListener arg0) {
            this.listener.remove(arg0);
        }

        private void fireListUpdate() {
            Iterator i = this.listener.iterator();
            while (i.hasNext()) {
                ListDataListener l = (ListDataListener)i.next();
                l.contentsChanged(new ListDataEvent(this, 0, 0, this.stringList.size()));
            }
        }

        public void add(String string) {
            this.stringList.add(string);
            this.fireListUpdate();
        }

        public String remove(int index) {
            String value = (String)this.stringList.remove(index);
            this.fireListUpdate();
            return value;
        }

        public List getStringList() {
            return this.stringList;
        }

        public void setStringList(List stringList) {
            this.stringList = stringList;
            this.fireListUpdate();
        }
    }
}

