/*
 * Decompiled with CFR 0.152.
 */
package de.miethxml.toolkit.gui.help;

import de.miethxml.toolkit.cache.GUICache;
import de.miethxml.toolkit.conf.ConfigManager;
import de.miethxml.toolkit.conf.LocaleImpl;
import de.miethxml.toolkit.conf.LocaleListener;
import de.miethxml.toolkit.gui.help.HelpBrowser;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class HelpAction
extends AbstractAction
implements LocaleListener,
Serviceable,
Initializable {
    private String defaultURL = "index.htm";
    private ServiceManager manager;

    public HelpAction() {
        super(LocaleImpl.getInstance().getString("common.help"), new ImageIcon("icons/help.gif"));
        this.putValue("ShortDescription", LocaleImpl.getInstance().getString("common.help"));
        LocaleImpl.getInstance().addLocaleListener(this);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("F1"));
    }

    public HelpAction(String url) {
        this();
        this.setDefaultURL(url);
    }

    public HelpAction(String name, Icon icon) {
        super(name, icon);
    }

    public void actionPerformed(ActionEvent e) {
        HelpBrowser hb;
        String url = "file:" + ConfigManager.getInstance().getProperty("help.path") + File.separator + ConfigManager.getInstance().getProperty("lang") + File.separator;
        url = this.defaultURL != null ? String.valueOf(url) + this.defaultURL : String.valueOf(url) + e.getActionCommand();
        if (!GUICache.getInstance().cached("help.browser")) {
            hb = new HelpBrowser();
            GUICache.getInstance().addComponent("help.browser", hb);
        }
        if ((hb = (HelpBrowser)GUICache.getInstance().getComponent("help.browser")) != null) {
            hb.show();
            hb.setPage(url);
        }
    }

    public void langChanged() {
        this.putValue("ShortDescription", LocaleImpl.getInstance().getString("common.help"));
        this.putValue("Name", LocaleImpl.getInstance().getString("common.help"));
    }

    public void setDefaultURL(String defaultURL) {
        this.defaultURL = defaultURL;
    }

    public void initialize() {
    }

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
    }
}

