/*
 * Decompiled with CFR 0.152.
 */
package de.miethxml.toolkit.io;

import de.miethxml.toolkit.io.DefaultFileModelContent;
import de.miethxml.toolkit.io.FileModel;
import de.miethxml.toolkit.io.FileModelContent;
import de.miethxml.toolkit.io.FileModelException;
import java.io.File;

public class DefaultFileModel
implements FileModel {
    private File f;
    private int childCount = -1;
    private FileModel parent;

    public DefaultFileModel(File f, FileModel parent) {
        this.f = f;
        this.parent = parent;
    }

    public boolean isFile() {
        return this.f.isFile();
    }

    public long lastModified() {
        return this.f.lastModified();
    }

    public String getName() {
        return this.f.getName();
    }

    public String getPath() {
        return this.f.getAbsolutePath();
    }

    public FileModel getParent() {
        return this.parent;
    }

    public int getChildCount() {
        if (this.childCount == -1) {
            File[] children = this.f.listFiles();
            this.childCount = children != null ? this.f.listFiles().length : 0;
        }
        return this.childCount;
    }

    public FileModel getChild(int index) {
        if (index < this.getChildCount()) {
            File[] childs = this.f.listFiles();
            return new DefaultFileModel(childs[index], this);
        }
        return null;
    }

    public long getLength() {
        return this.f.length();
    }

    public FileModel[] getChildren() {
        File[] childs = this.f.listFiles();
        if (childs != null) {
            FileModel[] children = new FileModel[childs.length];
            int i = 0;
            while (i < childs.length) {
                children[i] = new DefaultFileModel(childs[i], this);
                ++i;
            }
            return children;
        }
        return new FileModel[0];
    }

    public String toString() {
        return this.getName();
    }

    public void renameTo(String name) {
        File newfile = new File(String.valueOf(this.f.getParentFile().getAbsolutePath()) + File.separator + name);
        this.f.renameTo(newfile);
        this.f = newfile;
        this.childCount = -1;
    }

    public FileModelContent getContent() {
        return new DefaultFileModelContent(this.f);
    }

    public boolean delete() {
        return this.f.delete();
    }

    public boolean exists() {
        return this.f.exists();
    }

    public FileModel createDirectory(String name) throws FileModelException {
        File dir;
        File parent = this.f;
        if (this.f.isFile()) {
            parent = this.f.getParentFile();
        }
        if ((dir = new File(parent, name)).mkdir()) {
            return new DefaultFileModel(dir, this);
        }
        throw new FileModelException("Could not create directory:" + name);
    }

    public FileModel createFile(String name) throws FileModelException {
        File parent = this.f;
        if (this.f.isFile()) {
            parent = this.f.getParentFile();
        }
        File file = new File(parent, name);
        return new DefaultFileModel(file, this);
    }
}

