/*
 * Decompiled with CFR 0.152.
 */
package de.miethxml.toolkit.io;

import de.miethxml.toolkit.io.FileModel;
import de.miethxml.toolkit.io.FileModelContent;
import de.miethxml.toolkit.io.FileModelException;
import de.miethxml.toolkit.io.VFSFileModelContent;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;

public class VFSFileModel
implements FileModel {
    private FileObject f;
    private int childCount = -1;
    private FileModel parent;

    public VFSFileModel(FileObject f, FileModel parent) {
        this.f = f;
        this.parent = parent;
    }

    public boolean isFile() {
        try {
            if (this.f.getType().equals(FileType.FILE)) {
                return true;
            }
        }
        catch (FileSystemException e) {
            e.printStackTrace();
        }
        return false;
    }

    public long lastModified() {
        try {
            return this.f.getContent().getLastModifiedTime();
        }
        catch (FileSystemException fileSystemException) {
            return 0L;
        }
    }

    public long getLength() {
        try {
            return this.f.getContent().getSize();
        }
        catch (FileSystemException e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public String getName() {
        return this.f.getName().getBaseName();
    }

    public void renameTo(String name) {
        try {
            FileObject parent = this.f;
            if (this.f.getType().equals(FileType.FILE)) {
                parent = this.f.getParent();
            }
            FileObject newFile = parent.resolveFile(name);
            int count = 0;
            while (!this.f.canRenameTo(newFile) && count < 20) {
                newFile = parent.resolveFile(String.valueOf(name) + count);
                ++count;
            }
            this.f.moveTo(newFile);
            this.f = newFile;
        }
        catch (FileSystemException e) {
            e.printStackTrace();
        }
    }

    public String getPath() {
        String path = this.f.getName().getURI();
        if (path.indexOf(64) != -1) {
            path = path.replaceAll("\\/\\/(.*?)\\@", "//");
        }
        return path;
    }

    public FileModel getParent() {
        return this.parent;
    }

    public int getChildCount() {
        if (this.childCount == -1) {
            try {
                this.childCount = this.f.getChildren().length;
            }
            catch (FileSystemException e) {
                this.childCount = 0;
                e.printStackTrace();
            }
        }
        return this.childCount;
    }

    public FileModel getChild(int index) {
        try {
            return new VFSFileModel(this.f.getChildren()[index], this);
        }
        catch (FileSystemException e) {
            e.printStackTrace();
            return null;
        }
    }

    public FileModel[] getChildren() throws FileModelException {
        try {
            FileObject[] children = this.f.getChildren();
            FileModel[] models = new VFSFileModel[children.length];
            int i = 0;
            while (i < children.length) {
                models[i] = new VFSFileModel(children[i], this);
                ++i;
            }
            return models;
        }
        catch (FileSystemException e) {
            throw new FileModelException((Exception)((Object)e));
        }
    }

    public String toString() {
        return this.getName();
    }

    public FileModelContent getContent() {
        return new VFSFileModelContent(this.f);
    }

    public boolean delete() {
        try {
            return this.f.delete();
        }
        catch (FileSystemException e) {
            return false;
        }
    }

    public boolean exists() {
        try {
            return this.f.exists();
        }
        catch (FileSystemException e) {
            return false;
        }
    }

    public FileModel createDirectory(String name) throws FileModelException {
        FileObject dir = null;
        try {
            FileObject parent = this.f;
            if (parent.getType().equals(FileType.FILE)) {
                parent = parent.getParent();
            }
            dir = parent.resolveFile(name);
            dir.createFolder();
            return new VFSFileModel(dir, this);
        }
        catch (FileSystemException e) {
            throw new FileModelException("Could not create directory:" + name + " " + e.getMessage());
        }
    }

    public FileModel createFile(String name) throws FileModelException {
        try {
            FileObject file = this.f.resolveFile(name);
            return new VFSFileModel(file, this);
        }
        catch (FileSystemException e) {
            throw new FileModelException("Could not create file:" + name + " " + e.getMessage());
        }
    }
}

