/*
 * Decompiled with CFR 0.152.
 */
package de.miethxml.toolkit.plugins;

import de.miethxml.toolkit.classloader.PluginClassLoader;
import de.miethxml.toolkit.plugins.Plugin;
import de.miethxml.toolkit.plugins.PluginConfig;
import de.miethxml.toolkit.plugins.PluginManager;
import de.miethxml.toolkit.plugins.PluginReceiver;
import de.miethxml.toolkit.plugins.xml.SAXPluginBuilder;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.apache.log.Logger;

public class PluginManagerImpl
implements PluginManager {
    static PluginManagerImpl instance;
    private Logger log;
    private String pluginDir = "";
    private ArrayList plugins;
    private ArrayList listeners;
    private Hashtable objects;
    private ArrayList pluginLocations;
    private HashSet pluginNames = new HashSet();

    public PluginManagerImpl() {
        this.plugins = new ArrayList();
        this.listeners = new ArrayList();
        this.objects = new Hashtable();
        this.pluginLocations = new ArrayList();
    }

    public static synchronized PluginManagerImpl getInstance() {
        if (instance == null) {
            instance = new PluginManagerImpl();
        }
        return instance;
    }

    public void findPlugins(String pluginDir) {
        File dir = new File(pluginDir);
        if (dir.isDirectory()) {
            this.pluginLocations.add(dir.getAbsolutePath());
            SAXPluginBuilder saxloader = new SAXPluginBuilder();
            File[] plugindirs = dir.listFiles();
            int i = 0;
            while (i < plugindirs.length) {
                if (plugindirs[i].isDirectory() && !this.isAlreadyLoadedPlugin(plugindirs[i].getAbsolutePath())) {
                    File descriptor = new File(String.valueOf(plugindirs[i].getAbsolutePath()) + File.separator + "plugin.xml");
                    if (descriptor.exists()) {
                        this.addPlugin(plugindirs[i]);
                    } else {
                        this.log.info("no plugin.xml inside plugindirectory: " + plugindirs[i].getAbsolutePath());
                    }
                }
                ++i;
            }
        }
    }

    public List getPluginsByInterface(String interfaceName) {
        ArrayList<PluginConfig> searchedPlugins = new ArrayList<PluginConfig>();
        Iterator i = this.plugins.iterator();
        while (i.hasNext()) {
            PluginConfig plugin = (PluginConfig)i.next();
            if (!plugin.getInterfaceName().equals(interfaceName)) continue;
            searchedPlugins.add(plugin);
        }
        return searchedPlugins;
    }

    private Object getPluginObject(PluginConfig plugin) {
        Object obj = null;
        this.log.debug("create new PluginObject for plugin:" + plugin.getName());
        PluginClassLoader cl = new PluginClassLoader(this.getClass().getClassLoader());
        String path = plugin.getBaseUri();
        String[] jars = plugin.getClasspath();
        int x = 0;
        while (x < jars.length) {
            this.log.debug("add plugin jar=" + jars[x] + " for plugin: " + plugin.getName());
            cl.addJarLibrary(String.valueOf(path) + File.separator + jars[x]);
            ++x;
        }
        try {
            Class c = cl.loadClass(plugin.getInstanceClass());
            try {
                obj = c.newInstance();
                if (obj instanceof Plugin) {
                    this.log.debug("Plugin=" + plugin.getName() + " is Plugin setContextPath=" + plugin.getBaseUri());
                    ((Plugin)obj).setContextPath(plugin.getBaseUri());
                }
            }
            catch (InstantiationException e1) {
                this.log.error("could not load plugin: " + plugin.getName());
                this.log.error(e1.getMessage());
            }
            catch (IllegalAccessException e1) {
                this.log.error("could not load plugin: " + plugin.getName());
                this.log.error(e1.getMessage());
            }
        }
        catch (ClassNotFoundException e) {
            this.log.error("could not load plugin: " + plugin.getName());
            this.log.error(e.getMessage());
        }
        return obj;
    }

    public void addPluginReceiver(PluginReceiver listener) {
        this.listeners.add(listener);
        if (this.log.isDebugEnabled()) {
            this.log.debug("addPluginReciver:" + listener.getClass().getName());
        }
        this.verifyPluginsForListener(listener);
    }

    public void removePluginReceiver(PluginReceiver listener) {
        this.listeners.remove(listener);
    }

    private void verifyPluginsForListener(PluginReceiver listener) {
        Collection c = listener.getInterfaces();
        Iterator f = c.iterator();
        if (this.log.isDebugEnabled()) {
            while (f.hasNext()) {
                this.log.debug("PluginListener:" + listener.getClass().getName() + " looking for=" + (String)f.next());
            }
        }
        Enumeration e = this.objects.keys();
        while (e.hasMoreElements()) {
            PluginConfig p = (PluginConfig)e.nextElement();
            if (!c.contains(p.getInterfaceName()) && !c.contains("ALL PLUGINS")) continue;
            Object obj = this.objects.get(p);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Found Plugin:" + obj.getClass().getName() + " for:" + listener.getClass().getName());
            }
            listener.addPlugin(obj);
        }
        Iterator i = this.plugins.iterator();
        while (i.hasNext()) {
            PluginConfig p = (PluginConfig)i.next();
            if (!c.contains(p.getInterfaceName()) && !c.contains("ALL PLUGINS")) continue;
            Object obj = this.getPluginObject(p);
            listener.addPlugin(obj);
            this.objects.put(p, obj);
            i.remove();
        }
    }

    private synchronized void verifyListnersForPlugin(PluginConfig plugin) {
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            PluginReceiver l = (PluginReceiver)i.next();
            Collection c = l.getInterfaces();
            if (!c.contains(plugin.getInterfaceName()) && !c.contains("ALL PLUGINS")) continue;
            Object obj = this.objects.get(plugin);
            l.addPlugin(obj);
        }
    }

    private boolean isAlreadyLoadedPlugin(String path) {
        Iterator i = this.plugins.iterator();
        while (i.hasNext()) {
            PluginConfig plugin = (PluginConfig)i.next();
            if (!plugin.getBaseUri().equals(path)) continue;
            i.remove();
        }
        Enumeration e = this.objects.keys();
        while (e.hasMoreElements()) {
            PluginConfig plugin = (PluginConfig)e.nextElement();
            if (!plugin.getBaseUri().equals(path)) continue;
            return true;
        }
        return false;
    }

    private void addPlugin(File dir) {
        SAXPluginBuilder saxloader = new SAXPluginBuilder();
        PluginConfig pluginConfig = saxloader.parseURI(String.valueOf(dir.getAbsolutePath()) + File.separator + "plugin.xml");
        if (!this.pluginNames.contains(pluginConfig.getName())) {
            this.pluginNames.add(pluginConfig.getName());
            pluginConfig.setBaseUri(dir.getAbsolutePath());
            pluginConfig.setSystemID("" + dir.lastModified());
            Object obj = this.getPluginObject(pluginConfig);
            this.objects.put(pluginConfig, obj);
            this.verifyListnersForPlugin(pluginConfig);
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("Plugin:" + pluginConfig.getName() + " with path:" + dir.getAbsolutePath() + " always loaded before.");
        }
    }

    public List getPluginDirectories() {
        return this.pluginLocations;
    }

    public String getPluginInstallLocation() {
        return "plugins";
    }

    public void setLogger(Logger log) {
        this.log = log;
    }
}

