/*
 * Decompiled with CFR 0.152.
 */
package de.miethxml.toolkit.plugins.xml;

import de.miethxml.toolkit.conf.ConfigManager;
import de.miethxml.toolkit.plugins.PluginConfig;
import java.io.IOException;
import java.util.ArrayList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class SAXPluginBuilder
implements ContentHandler {
    StringBuffer buf = new StringBuffer();
    int DESCRIPTION_MODE = 0;
    int INSTANCECLASS_MODE = 1;
    int NAME_MODE = 2;
    int INTERFACE_MODE = 3;
    ArrayList classpath = new ArrayList();
    ArrayList resources = new ArrayList();
    PluginConfig plugin;

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.buf.append(ch, start, length);
    }

    public void endDocument() throws SAXException {
        int i;
        if (this.classpath.size() > 0) {
            String[] cpath = new String[this.classpath.size()];
            i = 0;
            while (i < this.classpath.size()) {
                cpath[i] = (String)this.classpath.get(i);
                ++i;
            }
            this.plugin.setClasspath(cpath);
        }
        if (this.resources.size() > 0) {
            String[] res = new String[this.resources.size()];
            i = 0;
            while (i < this.resources.size()) {
                res[i] = (String)this.resources.get(i);
                ++i;
            }
            this.plugin.setResources(res);
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (localName.equals("interface")) {
            this.plugin.setInterfaceName(this.buf.toString());
        } else if (localName.equals("name")) {
            this.plugin.setName(this.buf.toString());
        } else if (localName.equals("description")) {
            this.plugin.setDescription(this.buf.toString());
        } else if (localName.equals("instanceclass")) {
            this.plugin.setInstanceClass(this.buf.toString());
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void startDocument() throws SAXException {
        this.plugin = new PluginConfig();
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        this.buf.delete(0, this.buf.length());
        if (localName.equals("classpath")) {
            String src = atts.getValue(atts.getIndex("src"));
            this.classpath.add(src);
        } else if (localName.equals("resource")) {
            String src = atts.getValue(atts.getIndex("src"));
            this.resources.add(src);
        } else if (localName.equals("resources")) {
            this.classpath.clear();
            this.resources.clear();
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    public PluginConfig parseURI(String uri) {
        try {
            XMLReader saxparser = XMLReaderFactory.createXMLReader(ConfigManager.getInstance().getProperty("SAXParser"));
            saxparser.setContentHandler(this);
            saxparser.parse(uri);
        }
        catch (SAXException e) {
            System.err.println(e.getMessage());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.plugin;
    }
}

