/*
 * Decompiled with CFR 0.152.
 */
package de.miethxml.toolkit.repository.search;

import de.miethxml.hawron.gui.context.FileSystemModel;
import de.miethxml.hawron.project.Project;
import de.miethxml.toolkit.conf.LocaleImpl;
import de.miethxml.toolkit.io.DefaultFileModel;
import de.miethxml.toolkit.repository.Reloadable;
import de.miethxml.toolkit.repository.RepositorySelectionListener;
import de.miethxml.toolkit.repository.search.RepositoryIndexer;
import de.miethxml.toolkit.repository.search.SearchEngine;
import de.miethxml.toolkit.repository.search.SearchResult;
import de.miethxml.toolkit.repository.search.SearchResultListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;

public class SearchEngineImpl
implements ListSelectionListener,
SearchEngine {
    private ArrayList listeners = new ArrayList();
    private ArrayList results = new ArrayList();
    private ArrayList fsmListener;
    private ResultTableModel resultTableModel = new ResultTableModel();
    private String indexDir = "";
    private long lastIndex = -1L;
    private Properties props;
    private boolean initialized = false;
    private FileSystemModel dummy = new FileSystemModel(".");
    private RepositoryIndexer indexer = new RepositoryIndexer();
    private String query = "";
    private boolean interrupt = false;
    private boolean updateIndex = true;
    private SimpleDateFormat dateformat;
    private Date date;
    private String configLocation = "conf";
    private String searchRootPath = "";
    public final String CONFIGFILE = "lucene.properties";
    public final String EXTENSIONFILE = "lucene-extensions.properties";
    public final String LASTMODIEFIEDKEY = "lucene.index.lastmodifies";
    public final String INDEXDIRECTORYKEY = "lucene.index.directory";
    public final String INDEXDIRECTORY = "lucene_index";
    private NumberFormat sizeformat;
    private List fileExtensions;

    public SearchEngineImpl() {
        this.props = new Properties();
        this.fsmListener = new ArrayList();
        this.dateformat = new SimpleDateFormat(" EEE, dd. MMM yyyy hh:mm:ss");
        this.sizeformat = NumberFormat.getInstance();
        this.date = new Date();
        this.fileExtensions = new ArrayList();
        this.fileExtensions.add("*");
    }

    private void search(String indexDir, String q) {
        File index = new File(indexDir);
        if (index.exists() && index.isDirectory()) {
            try {
                IndexSearcher is = new IndexSearcher(indexDir);
                Query query = QueryParser.parse((String)q, (String)"contents", (Analyzer)new StandardAnalyzer());
                Hits hits = is.search(query);
                this.results.clear();
                int i = 0;
                while (i < hits.length()) {
                    Document doc = hits.doc(i);
                    SearchResult result = new SearchResult();
                    result.setFile(doc.get("filename"));
                    result.setScore(hits.score(i));
                    this.results.add(result);
                    ++i;
                }
                this.resultTableModel.fireTableUpdate();
                this.fireFinishedSearching(hits.length());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ParseException e1) {
                e1.printStackTrace();
            }
        }
    }

    public void search(String query) {
        this.query = query;
        this.interrupt = false;
        this.fireStartSearching();
        this.init();
        if (this.updateIndex) {
            this.indexer.cleanupIndex(this.indexDir);
            this.indexer.index(this.indexDir, this.searchRootPath, this.lastIndex);
        }
        if (!this.interrupt) {
            this.storeConfig();
            this.fireFinishIndexing();
            this.search(this.indexDir, this.query);
        }
    }

    public void addSearchResultListener(SearchResultListener l) {
        this.listeners.add(l);
    }

    public void removeSearchResultListener(SearchResultListener l) {
        this.listeners.remove(l);
    }

    private void fireStartSearching() {
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            SearchResultListener l = (SearchResultListener)i.next();
            l.startSearching();
        }
    }

    private void fireFinishIndexing() {
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            SearchResultListener l = (SearchResultListener)i.next();
            l.finishIndexing();
        }
    }

    private void fireFinishedSearching(int hits) {
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            SearchResultListener l = (SearchResultListener)i.next();
            l.finishSearching(hits);
        }
    }

    public Project getProject() {
        return null;
    }

    public void setProject(Project project) {
    }

    public TableModel getResultTableModel() {
        return this.resultTableModel;
    }

    private void init() {
        if (!this.initialized) {
            String file = String.valueOf(this.configLocation) + File.separator + this.CONFIGFILE;
            File conf = new File(file);
            if (conf.exists() && conf.isFile()) {
                this.props = new Properties();
                try {
                    this.props.load(new FileInputStream(conf));
                    if (this.props.containsKey(this.INDEXDIRECTORYKEY)) {
                        this.indexDir = this.props.getProperty(this.INDEXDIRECTORYKEY);
                    } else {
                        this.indexDir = String.valueOf(this.configLocation) + File.separator + this.INDEXDIRECTORY;
                        this.props.setProperty(this.INDEXDIRECTORYKEY, this.indexDir);
                        this.lastIndex = 0L;
                    }
                    if (this.props.containsKey(this.LASTMODIEFIEDKEY)) {
                        String value = this.props.getProperty(this.LASTMODIEFIEDKEY);
                        try {
                            this.lastIndex = Long.parseLong(value);
                        }
                        catch (NumberFormatException e1) {
                            this.lastIndex = 0L;
                        }
                    } else {
                        this.lastIndex = 0L;
                    }
                    this.initialized = true;
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                this.indexDir = String.valueOf(this.configLocation) + File.separator + "luceneindex";
                this.props.setProperty("lucene.index.directory", this.indexDir);
                this.initialized = true;
            }
        }
    }

    public void addFileSystemSelectionListener(RepositorySelectionListener l) {
        this.fsmListener.add(l);
    }

    public void removeFileSystemSelectionListener(RepositorySelectionListener l) {
        this.fsmListener.remove(l);
    }

    private void fireFileSelectedEvent(String path) {
        int i = 0;
        while (i < this.fsmListener.size()) {
            RepositorySelectionListener l = (RepositorySelectionListener)this.fsmListener.get(i);
            l.fileSelected((Reloadable)this.dummy, new DefaultFileModel(new File(path), null));
            ++i;
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        ListSelectionModel lsm = (ListSelectionModel)e.getSource();
        int first = lsm.getMinSelectionIndex();
        if (first > -1) {
            SearchResult result = (SearchResult)this.results.get(first);
            this.fireFileSelectedEvent(result.getFile());
        }
    }

    public void recycle() {
        this.initialized = false;
        this.results.clear();
    }

    private void storeConfig() {
        String file = String.valueOf(this.configLocation) + File.separator + this.CONFIGFILE;
        if (this.updateIndex) {
            this.lastIndex = System.currentTimeMillis();
            this.props.setProperty(this.LASTMODIEFIEDKEY, Long.toString(this.lastIndex));
        }
        try {
            this.props.store(new FileOutputStream(file), "Lucene configuration");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void interruptSearch() {
        this.interrupt = true;
        this.indexer.interruptIndexing();
        this.fireFinishedSearching(0);
    }

    public void setUpdateIndex(boolean state) {
        this.updateIndex = state;
    }

    public void setFileExtensions(List extensions) {
        this.fileExtensions = extensions;
        this.indexer.setFilter(this.fileExtensions);
        this.saveFileExtensions();
    }

    public void setConfigLocation(String configLocation) {
        if (configLocation != null) {
            this.configLocation = configLocation;
            this.recycle();
            this.init();
            this.loadFileExtension();
        } else {
            configLocation = "";
        }
    }

    public void setSearchRootPath(String rootPath) {
        this.searchRootPath = rootPath;
    }

    public List getFileExtensions() {
        return this.fileExtensions;
    }

    private void saveFileExtensions() {
        String file = String.valueOf(this.configLocation) + File.separator + this.EXTENSIONFILE;
        File f = new File(file);
        if (f.exists()) {
            try {
                BufferedWriter out = new BufferedWriter(new FileWriter(f));
                Iterator i = this.fileExtensions.iterator();
                while (i.hasNext()) {
                    out.write(String.valueOf((String)i.next()) + "\n");
                }
                out.flush();
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void loadFileExtension() {
        String file = String.valueOf(this.configLocation) + File.separator + this.EXTENSIONFILE;
        File f = new File(file);
        this.fileExtensions.clear();
        if (f.exists() && f.isFile()) {
            try {
                BufferedReader in = new BufferedReader(new FileReader(f));
                String line = null;
                while ((line = in.readLine()) != null) {
                    this.fileExtensions.add(line);
                }
                in.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        } else {
            this.fileExtensions.add("*");
        }
        this.indexer.setFilter(this.fileExtensions);
    }

    public class ResultTableModel
    implements TableModel {
        private ArrayList listeners;
        private TableModelEvent event;
        private DecimalFormat scoreFormat = new DecimalFormat(" ###.## % ");

        public ResultTableModel() {
            this.listeners = new ArrayList();
            this.event = new TableModelEvent(this);
        }

        public void addTableModelListener(TableModelListener l) {
            this.listeners.add(l);
        }

        public Class getColumnClass(int columnIndex) {
            return "".getClass();
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return LocaleImpl.getInstance().getString("search.result.table.header.file");
                }
                case 1: {
                    return LocaleImpl.getInstance().getString("search.result.table.header.score");
                }
            }
            return null;
        }

        public int getRowCount() {
            return SearchEngineImpl.this.results.size();
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            if (rowIndex >= 0 && rowIndex < SearchEngineImpl.this.results.size()) {
                SearchResult result = (SearchResult)SearchEngineImpl.this.results.get(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return result.getFile();
                    }
                    case 1: {
                        return this.scoreFormat.format(result.getScore());
                    }
                }
            }
            return null;
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public void removeTableModelListener(TableModelListener l) {
            this.listeners.remove(l);
        }

        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        }

        public void fireTableUpdate() {
            Iterator i = this.listeners.iterator();
            while (i.hasNext()) {
                TableModelListener l = (TableModelListener)i.next();
                l.tableChanged(this.event);
            }
        }
    }
}

