/*
 * Decompiled with CFR 0.152.
 */
package de.miethxml.toolkit.repository.search;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class ZipFileReader
extends Reader {
    private ZipFile file;
    private InputStreamReader in;

    public ZipFileReader(String file, String entry) {
        this.init(file, entry);
    }

    public void close() throws IOException {
        if (this.in == null) {
            throw new IOException("no inputstream");
        }
        this.in.close();
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.in != null) {
            return this.in.read(cbuf, off, len);
        }
        throw new IOException("no inputstream");
    }

    private void init(String file, String entry) {
        File f = new File(file);
        if (f.exists() && f.isFile()) {
            try {
                this.file = new ZipFile(f);
                ZipEntry ze = this.file.getEntry(entry);
                this.in = new InputStreamReader(this.file.getInputStream(ze));
            }
            catch (ZipException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void mark(int readAheadLimit) throws IOException {
        if (this.in == null) {
            throw new IOException("no inputstream");
        }
        this.in.mark(readAheadLimit);
    }

    public void reset() throws IOException {
        if (this.in == null) {
            throw new IOException("no inputstream");
        }
        this.in.reset();
    }

    public boolean markSupported() {
        if (this.in != null) {
            return this.in.markSupported();
        }
        return false;
    }

    public boolean ready() throws IOException {
        if (this.in != null) {
            return this.in.ready();
        }
        throw new IOException("no inputstream");
    }

    public long skip(long n) throws IOException {
        if (this.in != null) {
            return this.in.skip(n);
        }
        throw new IOException("no inputstream");
    }

    public int read(char[] cbuf) throws IOException {
        if (this.in != null) {
            return this.in.read(cbuf);
        }
        throw new IOException("no inputstream");
    }

    public int read() throws IOException {
        if (this.in != null) {
            return this.in.read();
        }
        throw new IOException("no inputstream");
    }
}

