/*
 * Decompiled with CFR 0.152.
 */
package de.miethxml.toolkit.repository.ui;

import de.miethxml.toolkit.io.DefaultFileModel;
import de.miethxml.toolkit.io.FileModel;
import de.miethxml.toolkit.io.FileModelByNameSorter;
import de.miethxml.toolkit.locale.LocaleService;
import de.miethxml.toolkit.locale.impl.DummyLocaleService;
import de.miethxml.toolkit.locale.ui.LocaleUIBuilder;
import de.miethxml.toolkit.repository.Reloadable;
import de.miethxml.toolkit.repository.RepositoryModelImpl;
import de.miethxml.toolkit.repository.RepositorySelectionController;
import de.miethxml.toolkit.repository.RepositorySelectionListener;
import de.miethxml.toolkit.repository.RepositoryTransferHandler;
import de.miethxml.toolkit.repository.ui.ArchivAction;
import de.miethxml.toolkit.repository.ui.RepositoryTableCellRenderer;
import de.miethxml.toolkit.ui.PanelFactory;
import java.awt.Color;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class RepositoryModelViewBuilder {
    private RepositoryModelImpl model;
    private JPopupMenu popupmenu;
    private RepositoryTransferHandler dndHandler;
    private RepositorySelectionController selectionController = new RepositorySelectionController();
    private MouseController mouseController = new MouseController();
    private boolean popupEnabled = false;
    private LocaleService locale;

    public RepositoryModelViewBuilder(RepositoryModelImpl model, JPopupMenu menu, LocaleService locale) {
        this.model = model;
        model.addFileModelSorter(new FileModelByNameSorter());
        model.addRepositorySelectionListener(this.mouseController);
        this.dndHandler = new RepositoryTransferHandler(model);
        if (locale == null) {
            locale = new DummyLocaleService();
        }
        if (menu != null) {
            LocaleUIBuilder builder = new LocaleUIBuilder(locale);
            this.popupmenu = menu;
            this.popupEnabled = true;
            JMenuItem menuitem = new JMenuItem(locale.getString("view.context.popupmenu.paste", "Paste"), new ImageIcon("icons/paste_edit.gif"));
            menuitem.setAccelerator(KeyStroke.getKeyStroke("control v"));
            menuitem.setActionCommand(RepositoryTransferHandler.ACTION_PASTE);
            menuitem.addActionListener(this.dndHandler);
            this.popupmenu.add(menuitem);
            menuitem = builder.getMenuItem("view.context.popupmenu.import", "Import");
            menuitem.setActionCommand(RepositoryTransferHandler.ACTION_IMPORT);
            menuitem.addActionListener(this.dndHandler);
            this.popupmenu.add(menuitem);
            menuitem = new JMenuItem(new ArchivAction(model, locale));
            this.popupmenu.add(menuitem);
        } else {
            this.popupEnabled = false;
        }
    }

    public JComponent getTreeAndTableView() {
        JSplitPane sp = PanelFactory.createDefaultSplitPane();
        JScrollPane scroll = new JScrollPane(this.getRepositoryTree(false));
        sp.setLeftComponent(scroll);
        JScrollPane scroll2 = new JScrollPane(this.getRepositoryTable());
        scroll2.getViewport().setBackground(Color.white);
        scroll2.getViewport().setOpaque(true);
        sp.setRightComponent(scroll2);
        sp.setPreferredSize(sp.getPreferredSize());
        sp.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                ((JSplitPane)e.getSource()).setDividerLocation(0.35);
            }
        });
        return sp;
    }

    public JTree getRepositoryTree(boolean mixed) {
        if (mixed) {
            UIManager.put("Tree.leafIcon", new ImageIcon("icons/file.gif"));
            UIManager.put("Tree.closedIcon", new ImageIcon("icons/dir.gif"));
            UIManager.put("Tree.openIcon", new ImageIcon("icons/opendir.gif"));
        } else {
            UIManager.put("Tree.leafIcon", new ImageIcon("icons/dir.gif"));
            UIManager.put("Tree.closedIcon", new ImageIcon("icons/dir.gif"));
            UIManager.put("Tree.openIcon", new ImageIcon("icons/opendir.gif"));
        }
        JTree tree = new JTree(this.model.getTreeModel(mixed));
        tree.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        tree.setDragEnabled(true);
        tree.setTransferHandler(this.dndHandler);
        this.selectionController.setFileSystemTree(tree);
        tree.addTreeSelectionListener(this.model);
        tree.addMouseListener(this.mouseController);
        tree.addMouseMotionListener(this.mouseController);
        return tree;
    }

    public JTable getRepositoryTable() {
        JTable table = new JTable(this.model.getTableModel());
        table.setDragEnabled(true);
        table.setTransferHandler(this.dndHandler);
        this.selectionController.setFileSystemTable(table);
        table.getSelectionModel().addListSelectionListener(this.model);
        table.setShowVerticalLines(false);
        TableColumnModel tcm = table.getColumnModel();
        TableColumn column = tcm.getColumn(0);
        column.setCellRenderer(new RepositoryTableCellRenderer());
        column.setPreferredWidth(16);
        column.setMaxWidth(16);
        column.setMinWidth(16);
        table.setRowHeight(16);
        table.addMouseListener(this.mouseController);
        table.addMouseMotionListener(this.mouseController);
        return table;
    }

    private class MouseController
    extends MouseAdapter
    implements MouseMotionListener,
    RepositorySelectionListener {
        private boolean prepareDnD = false;
        private String selectedFile = "";
        private boolean popupprocessed = false;
        private FileModel selection;
        private FileModel dummy = new DefaultFileModel(new File(""), null);

        MouseController() {
        }

        public void mouseDragged(MouseEvent e) {
            if (!this.prepareDnD && !this.selectedFile.equals(this.selection.getPath())) {
                JComponent c = (JComponent)e.getSource();
                RepositoryModelViewBuilder.this.dndHandler.exportAsDrag(c, e, 1);
                this.prepareDnD = true;
            }
        }

        public void mouseMoved(MouseEvent e) {
        }

        public void mouseClicked(MouseEvent e) {
            this.prepareDnD = false;
            if (e.getClickCount() == 2) {
                RepositoryModelViewBuilder.this.model.expandSelectedFileModel();
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                if (!this.popupprocessed) {
                    this.showPopup(e);
                } else {
                    this.popupprocessed = false;
                }
            }
        }

        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.popupprocessed = true;
                this.showPopup(e);
            } else {
                this.prepareDnD = false;
                this.selectedFile = this.selection.getPath();
            }
        }

        private void showPopup(MouseEvent e) {
            if (RepositoryModelViewBuilder.this.popupEnabled) {
                RepositoryModelViewBuilder.this.popupmenu.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        public void directorySelected(Reloadable model, FileModel directory) {
            this.selection = directory;
        }

        public void fileSelected(Reloadable model, FileModel file) {
            this.selection = file;
        }

        public void unselect() {
            this.selection = this.dummy;
        }
    }
}

