/*
 * Decompiled with CFR 0.152.
 */
package de.miethxml.toolkit.repository.ui.action;

import de.miethxml.toolkit.component.Configurable;
import de.miethxml.toolkit.conf.LocaleImpl;
import de.miethxml.toolkit.gui.ButtonPanel;
import de.miethxml.toolkit.io.FileModel;
import de.miethxml.toolkit.locale.LocaleChangeListener;
import de.miethxml.toolkit.locale.LocaleService;
import de.miethxml.toolkit.plugins.PluginReceiver;
import de.miethxml.toolkit.repository.Reloadable;
import de.miethxml.toolkit.repository.RepositorySelectionListener;
import de.miethxml.toolkit.repository.ui.action.CreateDirectoryAction;
import de.miethxml.toolkit.repository.ui.action.DeleteAction;
import de.miethxml.toolkit.repository.ui.action.MenuAction;
import de.miethxml.toolkit.repository.ui.action.RefreshAction;
import de.miethxml.toolkit.repository.ui.action.RepositoryAction;
import de.miethxml.toolkit.repository.ui.action.ValidationAction;
import de.miethxml.toolkit.repository.ui.action.XMLFormatAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.JMenu;
import javax.swing.JPanel;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;

public class ActionManager
implements Configurable,
LocaleChangeListener,
PluginReceiver,
RepositorySelectionListener,
Initializable,
Disposable {
    private ArrayList brokenActions = new ArrayList();
    private ArrayList setupActions = new ArrayList();
    private Collection interfaces = new HashSet();
    private ArrayList actions = new ArrayList();
    private ButtonPanel buttonpanel;
    private JMenu menu;
    private boolean checksupportedextensions = true;
    private LocaleService locale;
    static /* synthetic */ Class class$0;

    public ActionManager(LocaleService locale) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.miethxml.toolkit.repository.ui.action.RepositoryAction");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.interfaces.add(clazz.getName());
        this.locale = locale;
    }

    public void initialize() {
        this.buttonpanel = new ButtonPanel("action.buttonpanel.menu.title");
        this.buttonpanel.init();
        this.menu = new JMenu(this.locale.getString("action.buttonpanel.menu.title", "Action"));
        this.locale.addLocaleChangeListener(this);
        this.initActions();
    }

    public boolean isSetup() {
        return false;
    }

    public void setup() {
        Iterator i = this.setupActions.iterator();
        while (i.hasNext()) {
            Configurable conf = (Configurable)i.next();
            conf.setup();
        }
        i = this.brokenActions.iterator();
        while (i.hasNext()) {
            RepositoryAction act = (RepositoryAction)i.next();
            Configurable conf = (Configurable)((Object)act);
            conf.setup();
            if (!conf.isSetup()) continue;
            this.addAction(act);
            i.remove();
            this.setupActions.add(act);
        }
    }

    public void langChanged() {
        this.menu.setText(LocaleImpl.getInstance().getString("action.buttonpanel.menu.title"));
    }

    public void addPlugin(Object obj) {
        RepositoryAction action = (RepositoryAction)obj;
        this.addAction(action);
    }

    public Collection getInterfaces() {
        return this.interfaces;
    }

    public void removePlugin(Object obj) {
    }

    private void addAction(RepositoryAction act) {
        if (act instanceof Configurable) {
            Configurable conf = (Configurable)((Object)act);
            conf.setup();
            if (conf.isSetup()) {
                this.setupActions.add(act);
            } else {
                this.brokenActions.add(act);
                return;
            }
        }
        MenuAction action = new MenuAction(act);
        action.setCheckSupportedExtensions(this.checksupportedextensions);
        this.buttonpanel.addAction(action);
        this.menu.add(action);
    }

    private void initActions() {
        this.actions.clear();
        RepositoryAction action = new CreateDirectoryAction();
        this.addAction(action);
        action = new RefreshAction();
        this.addAction(action);
        action = new DeleteAction();
        this.addAction(action);
        action = new ValidationAction();
        this.addAction(action);
        action = new XMLFormatAction();
        this.addAction(action);
    }

    public JPanel getButtonPanel() {
        return this.buttonpanel;
    }

    public JMenu getActionMenu() {
        return this.menu;
    }

    public void dispose() {
    }

    public void setCheckSupportedExtensions(boolean b) {
        this.checksupportedextensions = b;
        Iterator i = this.actions.iterator();
        while (i.hasNext()) {
            MenuAction action = (MenuAction)i.next();
            action.setCheckSupportedExtensions(b);
        }
    }

    public void directorySelected(Reloadable model, FileModel directory) {
        Iterator i = this.actions.iterator();
        while (i.hasNext()) {
            MenuAction action = (MenuAction)i.next();
            action.directorySelected(model, directory);
        }
    }

    public void fileSelected(Reloadable model, FileModel file) {
        Iterator i = this.actions.iterator();
        while (i.hasNext()) {
            MenuAction action = (MenuAction)i.next();
            action.fileSelected(model, file);
        }
    }

    public void unselect() {
        Iterator i = this.actions.iterator();
        while (i.hasNext()) {
            MenuAction action = (MenuAction)i.next();
            action.unselect();
        }
    }

    public void localeChanged(LocaleService locale) {
        this.menu.setText(locale.getString("action.buttonpanel.menu.title", "Actions"));
    }
}

