/*
 * Decompiled with CFR 0.152.
 */
package de.miethxml.toolkit.repository.ui.action;

import de.miethxml.toolkit.io.FileModel;
import de.miethxml.toolkit.io.FileModelException;
import de.miethxml.toolkit.repository.ui.action.FileModelAction;
import de.miethxml.toolkit.repository.ui.action.RepositoryAction;
import java.io.File;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

public class DeleteAction
implements RepositoryAction,
FileModelAction {
    public void doAction(String uri) {
        File f = new File(uri);
        String msg = "";
        if (f.isDirectory()) {
            msg = "Are you sure to delete directory and all subdirectories " + uri;
        } else if (f.isFile()) {
            msg = "Are you sure to delete file " + uri;
        }
        int option = JOptionPane.showConfirmDialog(null, msg, "Delete?", 0);
        if (option == 0) {
            this.delete(f);
        }
    }

    public Icon getIcon() {
        ImageIcon icon = new ImageIcon("icons/delete.gif");
        return icon;
    }

    public boolean isSupported(String extention) {
        return true;
    }

    public boolean isHandleDirectory() {
        return true;
    }

    public boolean isHandleFile() {
        return true;
    }

    public String getToolTip(String lang) {
        return "Delete";
    }

    private void delete(File f) {
        if (f.exists() && f.isDirectory()) {
            File[] entries = f.listFiles();
            int i = 0;
            while (i < entries.length) {
                this.delete(entries[i]);
                ++i;
            }
            f.delete();
        } else {
            f.delete();
        }
    }

    public void doAction(FileModel model) {
        String msg = "";
        msg = !model.isFile() ? "Are you sure to delete directory and all subdirectories " + model.getPath() : "Are you sure to delete file " + model.getPath();
        int option = JOptionPane.showConfirmDialog(null, msg, "Delete?", 0);
        if (option == 0) {
            this.delete(model);
        }
    }

    private void delete(FileModel f) {
        if (f.exists()) {
            if (f.isFile()) {
                f.delete();
            } else {
                try {
                    FileModel[] children = f.getChildren();
                    int i = 0;
                    while (i < children.length) {
                        this.delete(children[i]);
                        ++i;
                    }
                }
                catch (FileModelException e) {
                    e.printStackTrace();
                }
                f.delete();
            }
        }
    }
}

