/*
 * Decompiled with CFR 0.152.
 */
package de.miethxml.toolkit.repository.ui.action;

import de.miethxml.toolkit.conf.ConfigManager;
import de.miethxml.toolkit.io.FileModel;
import de.miethxml.toolkit.repository.Reloadable;
import de.miethxml.toolkit.repository.RepositoryModel;
import de.miethxml.toolkit.repository.RepositorySelectionListener;
import de.miethxml.toolkit.repository.ui.action.FileModelAction;
import de.miethxml.toolkit.repository.ui.action.RepositoryAction;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

public class MenuAction
extends AbstractAction
implements RepositorySelectionListener {
    private RepositoryAction action;
    private boolean directorySelected;
    private String selectedPath;
    private Reloadable model;
    private FileModel selectedModel;
    private boolean fileModelAction = false;
    private boolean checksupportedextensions = true;

    public MenuAction(RepositoryAction action) {
        super(action.getToolTip(ConfigManager.getInstance().getProperty("lang")), action.getIcon());
        this.putValue("ShortDescription", action.getToolTip(ConfigManager.getInstance().getProperty("lang")));
        this.action = action;
        this.selectedPath = "";
        this.setEnabled(false);
        if (action instanceof FileModelAction) {
            this.fileModelAction = true;
        }
    }

    public void actionPerformed(ActionEvent e) {
        Runnable r = new Runnable(){

            public void run() {
                if (MenuAction.this.fileModelAction) {
                    ((FileModelAction)((Object)MenuAction.this.action)).doAction(MenuAction.this.selectedModel);
                } else {
                    MenuAction.this.action.doAction(MenuAction.this.selectedPath);
                }
                MenuAction.this.model.reload();
            }
        };
        Thread t = new Thread(r);
        t.start();
    }

    public void directorySelected(Reloadable model, FileModel directory) {
        this.selectedPath = directory.getPath();
        this.model = model;
        this.directorySelected = true;
        this.selectedModel = directory;
        if (this.action.isHandleDirectory()) {
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
        }
    }

    public void fileSelected(Reloadable model, FileModel file) {
        this.selectedPath = file.getPath();
        this.model = model;
        this.directorySelected = false;
        this.selectedModel = file;
        if (!this.action.isSupported(this.selectedPath) && this.action.isHandleFile() && this.checksupportedextensions) {
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
        }
    }

    public void setFileSystemModel(RepositoryModel model) {
        model.addRepositorySelectionListener(this);
    }

    public void unselect() {
        this.setEnabled(false);
    }

    public void setCheckSupportedExtensions(boolean check) {
        this.checksupportedextensions = check;
        if (!check) {
            this.setEnabled(true);
        }
    }
}

