/*
 * Decompiled with CFR 0.152.
 */
package de.miethxml.toolkit.repository.ui.action;

import de.miethxml.toolkit.conf.ConfigManager;
import de.miethxml.toolkit.io.FileModel;
import de.miethxml.toolkit.repository.ui.action.FileModelAction;
import de.miethxml.toolkit.repository.ui.action.RepositoryAction;
import de.miethxml.toolkit.ui.GradientLabel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class ValidationAction
implements RepositoryAction,
ErrorHandler,
FileModelAction {
    private StringBuffer msg;
    private boolean error = false;
    private boolean warn = false;
    private boolean initialized = false;
    private String errormsg;
    private String warnmsg;
    private JDialog dialog;
    private JTextArea logview;
    private JScrollPane scroll;
    private GradientLabel label;
    private Color red = new Color(255, 152, 152);

    public ValidationAction() {
        this.msg = new StringBuffer();
    }

    public void doAction(String uri) {
        this.errormsg = "";
        this.warnmsg = "";
        this.msg.delete(0, this.msg.length());
        File f = new File(uri);
        this.initialize();
        this.msg.append("File:" + f.getName() + "\n");
        try {
            if (this.validateFile(new FileInputStream(f), f.getAbsolutePath()) && !this.error) {
                this.label.setTextColor(Color.WHITE);
                this.label.setText("Valid");
                this.msg.append("This file is wellformed or valid.\n");
            } else {
                this.label.setTextColor(this.red);
                this.label.setText("Invalid");
            }
        }
        catch (FileNotFoundException e) {
            this.label.setTextColor(this.red);
            this.label.setText("Invalid");
            this.msg.append(e.getMessage());
        }
        this.logview.setText(this.msg.toString());
        this.dialog.setVisible(true);
        f = null;
    }

    public Icon getIcon() {
        return new ImageIcon("icons/val.gif");
    }

    public boolean isSupported(String extention) {
        return true;
    }

    public boolean isHandleDirectory() {
        return false;
    }

    public boolean isHandleFile() {
        return true;
    }

    public String getToolTip(String lang) {
        return "Validation";
    }

    private boolean validateFile(InputStream in, String systemId) {
        this.error = false;
        this.warn = false;
        XMLReader saxparser = null;
        try {
            saxparser = XMLReaderFactory.createXMLReader(ConfigManager.getInstance().getProperty("SAXParser"));
            saxparser.setFeature("http://apache.org/xml/features/validation/dynamic", true);
            saxparser.setErrorHandler(this);
            InputSource source = new InputSource(in);
            source.setSystemId(systemId);
            saxparser.parse(source);
        }
        catch (SAXException e) {
            this.msg.append("[Error] " + e.getLocalizedMessage() + "\n");
            this.error = true;
        }
        catch (IOException ioe) {
            this.msg.append("[Error] " + ioe.getLocalizedMessage() + "\n");
            this.error = true;
        }
        saxparser = null;
        return !this.warn && !this.error;
    }

    public void error(SAXParseException arg0) throws SAXException {
        this.error = true;
        this.msg.append("[Error] line:" + arg0.getLineNumber() + "\n" + "[Error] message:" + arg0.getLocalizedMessage() + "\n");
    }

    public void fatalError(SAXParseException arg0) throws SAXException {
        this.error = true;
        this.errormsg.concat(" " + arg0.getLocalizedMessage());
        this.msg.append("[FatalError] line:" + arg0.getLineNumber() + "\n" + "[FatalError] message:" + arg0.getLocalizedMessage() + "\n");
    }

    public void warning(SAXParseException arg0) throws SAXException {
        this.warn = true;
        this.msg.append("[Warn] line:" + arg0.getLineNumber() + "\n" + "[Warn] message:" + arg0.getLocalizedMessage() + "\n");
    }

    private void initialize() {
        if (!this.initialized) {
            this.dialog = new JDialog();
            this.dialog.setTitle("XMLValidation");
            this.dialog.getContentPane().setLayout(new BorderLayout());
            this.label = new GradientLabel();
            this.dialog.getContentPane().add((Component)this.label, "North");
            this.logview = new JTextArea(5, 15);
            this.logview.setEditable(false);
            this.scroll = new JScrollPane(this.logview);
            this.dialog.getContentPane().add((Component)this.scroll, "Center");
            this.dialog.setSize(new Dimension(400, 300));
            this.initialized = true;
        }
    }

    public void doAction(FileModel model) {
        this.errormsg = "";
        this.warnmsg = "";
        this.msg.delete(0, this.msg.length());
        this.initialize();
        this.msg.append("File:" + model.getPath() + "\n");
        try {
            if (this.validateFile(model.getContent().getInputStream(), model.getPath()) && !this.error) {
                this.label.setTextColor(Color.WHITE);
                this.label.setText("Valid");
                this.msg.append("This file is wellformed or valid.\n");
            } else {
                this.label.setTextColor(this.red);
                this.label.setText("Invalid");
            }
        }
        catch (Exception e) {
            this.label.setTextColor(this.red);
            this.label.setText("Invalid");
            this.msg.append(e.getMessage());
        }
        this.logview.setText(this.msg.toString());
        this.dialog.setVisible(true);
    }
}

