/*
 * Decompiled with CFR 0.152.
 */
package de.miethxml.toolkit.repository.ui.editor;

import de.miethxml.toolkit.conf.ConfigManager;
import de.miethxml.toolkit.io.FileModel;
import de.miethxml.toolkit.repository.Reloadable;
import de.miethxml.toolkit.repository.RepositoryModel;
import de.miethxml.toolkit.repository.RepositorySelectionListener;
import de.miethxml.toolkit.repository.ui.editor.CacheableEditor;
import de.miethxml.toolkit.repository.ui.editor.EditorCloseListener;
import de.miethxml.toolkit.repository.ui.editor.RepositoryEditor;
import de.miethxml.toolkit.repository.ui.editor.RepositoryStreamEditor;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.apache.avalon.framework.service.ServiceManager;

public class EditorAction
extends AbstractAction
implements EditorCloseListener,
RepositorySelectionListener {
    private ServiceManager manager;
    private List editorcache;
    private List active;
    private List closedEditors;
    private int CACHESIZE = 5;
    private boolean directorySelected;
    private String selectedPath;
    private Reloadable model;
    private RepositoryEditor editor;
    private boolean destroySelf = false;
    private EditorCloseListener listener;
    private boolean cacheable = false;
    private RepositoryEditor nonCacheable;
    private CacheableEditor cacheableEditor;
    private boolean checksupportedextensions = true;
    private boolean streamEditor = false;
    private FileModel fileModel;

    public EditorAction() {
        this.active = Collections.synchronizedList(new ArrayList());
        this.editorcache = Collections.synchronizedList(new ArrayList());
        this.closedEditors = Collections.synchronizedList(new ArrayList());
        this.listener = this;
    }

    public EditorAction(String name) {
        super(name);
    }

    public EditorAction(String name, Icon icon) {
        super(name, icon);
    }

    public EditorAction(RepositoryEditor editor) {
        super(editor.getToolTip(ConfigManager.getInstance().getProperty("lang")), editor.getIcon());
        this.putValue("ShortDescription", editor.getToolTip(ConfigManager.getInstance().getProperty("lang")));
        this.editor = editor;
        this.active = Collections.synchronizedList(new ArrayList());
        this.editorcache = Collections.synchronizedList(new ArrayList());
        this.closedEditors = Collections.synchronizedList(new ArrayList());
        if (editor instanceof CacheableEditor) {
            this.cacheable = true;
            this.editorcache.add(editor);
        } else {
            this.cacheable = false;
            this.nonCacheable = editor;
        }
        this.listener = this;
        this.setEnabled(false);
        if (editor instanceof RepositoryStreamEditor) {
            this.streamEditor = true;
        }
    }

    public void actionPerformed(ActionEvent e) {
        Runnable r = new Runnable(){

            public void run() {
                Thread.currentThread().setContextClassLoader(EditorAction.this.editor.getClass().getClassLoader());
                if (EditorAction.this.cacheable) {
                    if (EditorAction.this.editorcache.size() > 0) {
                        EditorAction.this.editor = (RepositoryEditor)EditorAction.this.editorcache.remove(EditorAction.this.editorcache.size() - 1);
                    } else {
                        EditorAction.this.editor = EditorAction.this.editor.createNewEditor();
                    }
                    if (EditorAction.this.editor != null) {
                        ((CacheableEditor)EditorAction.this.editor).addEditorCloseListener(EditorAction.this.listener);
                        EditorAction.this.active.add(EditorAction.this.editor);
                    }
                } else {
                    EditorAction.this.editor = EditorAction.this.nonCacheable.createNewEditor();
                }
                if (EditorAction.this.directorySelected) {
                    if (EditorAction.this.streamEditor) {
                        ((RepositoryStreamEditor)((Object)EditorAction.this.editor)).newFile(EditorAction.this.fileModel);
                    } else {
                        EditorAction.this.editor.newFile(EditorAction.this.selectedPath);
                    }
                } else if (EditorAction.this.streamEditor) {
                    ((RepositoryStreamEditor)((Object)EditorAction.this.editor)).open(EditorAction.this.fileModel);
                } else {
                    EditorAction.this.editor.open(EditorAction.this.selectedPath);
                }
                EditorAction.this.editor.setVisible(true);
            }
        };
        Thread t = new Thread(r);
        t.start();
    }

    public void close(CacheableEditor editor) {
        if (!this.destroySelf) {
            this.active.remove(editor);
            if (this.editorcache.size() < this.CACHESIZE - 1) {
                this.editorcache.add(editor);
                this.closedEditors.add(editor);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        EditorAction.this.removeListener();
                    }
                });
            } else {
                editor = null;
            }
        }
    }

    public void directorySelected(Reloadable model, FileModel directory) {
        this.selectedPath = directory.getPath();
        this.model = model;
        this.directorySelected = true;
        this.fileModel = directory;
        this.setEnabled(true);
    }

    public void fileSelected(Reloadable model, FileModel file) {
        this.selectedPath = file.getPath();
        this.fileModel = file;
        this.model = model;
        this.directorySelected = false;
        if (!this.editor.isSupported(this.selectedPath) && this.checksupportedextensions) {
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
        }
    }

    public void setFileSystemModel(RepositoryModel model) {
        model.addRepositorySelectionListener(this);
    }

    public String getToolTip() {
        return this.editor.getToolTip("");
    }

    public void destroy() {
        CacheableEditor cacheable;
        RepositoryEditor edit;
        this.destroySelf = true;
        Iterator i = this.editorcache.iterator();
        while (i.hasNext()) {
            edit = (RepositoryEditor)i.next();
            if (edit instanceof CacheableEditor) {
                cacheable = (CacheableEditor)edit;
                cacheable.destroy();
            }
            i.remove();
        }
        i = this.active.iterator();
        while (i.hasNext()) {
            edit = (RepositoryEditor)i.next();
            if (!(edit instanceof CacheableEditor)) continue;
            cacheable = (CacheableEditor)edit;
            cacheable.destroy();
        }
    }

    private void removeListener() {
        Iterator i = this.closedEditors.iterator();
        while (i.hasNext()) {
            CacheableEditor edit = (CacheableEditor)i.next();
            edit.removeEditorCloseListener(this);
            i.remove();
        }
    }

    public void unselect() {
        this.setEnabled(false);
    }

    public boolean isCheckSupportedExtensions() {
        return this.checksupportedextensions;
    }

    public void setCheckSupportedExtensions(boolean check) {
        this.checksupportedextensions = check;
        if (!check) {
            this.setEnabled(true);
        }
    }
}

