/*
 * Decompiled with CFR 0.152.
 */
package de.miethxml.toolkit.repository.ui.editor;

import de.miethxml.hawron.io.FileMatcher;
import de.miethxml.toolkit.component.Configurable;
import de.miethxml.toolkit.repository.ui.editor.EditorCloseListener;
import de.miethxml.toolkit.repository.ui.editor.RepositoryEditor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class ExternalEditor
implements RepositoryEditor,
Configurable {
    public static String PLATFORM_ALL = "all";
    private String command = "";
    private String name = "";
    private List handles = new ArrayList();
    private String platform = PLATFORM_ALL;
    private Icon icon;
    private String open = "";
    private String iconurl = "";
    private String file = "";
    private String execute = "";
    private String start = "";
    private String end = "";
    private FileMatcher matcher = new FileMatcher();

    public void setContextPath(String path) {
    }

    public boolean isSetup() {
        return this.isSupportedPlatform();
    }

    public JComponent getSetup() {
        return null;
    }

    public void setup() {
    }

    public void init() {
    }

    public void open(String file) {
        this.file = file;
    }

    public boolean isSupported(String extension) {
        return this.matcher.matches(extension);
    }

    public void save() {
    }

    public void dispose() {
    }

    public void destroy() {
    }

    public void newFile(String file) {
        this.file = file;
    }

    public void setVisible(boolean state) {
        this.execute = String.valueOf(this.start) + this.file + this.end;
        try {
            Runtime.getRuntime().exec(this.execute);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Icon getIcon() {
        return this.icon;
    }

    public String getToolTip(String lang) {
        return this.name;
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
        if (command.indexOf("%s") > 0) {
            this.start = command.substring(0, command.indexOf("%s"));
            this.end = command.substring(command.indexOf("%s") + 2);
        } else {
            this.start = String.valueOf(command) + " ";
            this.end = "";
        }
    }

    public List getHandles() {
        return this.handles;
    }

    public void setHandles(List handles) {
        this.handles = handles;
        this.matcher.setPattern((Collection)this.handles);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public void setIcon(String file) {
        this.iconurl = file;
        this.icon = new ImageIcon(file);
    }

    public String getIconURL() {
        return this.iconurl;
    }

    public String getPlatform() {
        return this.platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public boolean isSupportedPlatform() {
        if (this.platform.equals(PLATFORM_ALL)) {
            return true;
        }
        String os = System.getProperty("os.name");
        return os.indexOf(this.platform) != -1;
    }

    public void addHandle(String handle) {
        this.handles.add(handle);
    }

    public void addEditorCloseListener(EditorCloseListener listener) {
    }

    public void removeEditorCloseListener(EditorCloseListener listener) {
    }

    public RepositoryEditor createNewEditor() {
        ExternalEditor edit = new ExternalEditor();
        edit.setCommand(this.getCommand());
        edit.setIcon(this.getIcon());
        edit.setHandles(this.getHandles());
        edit.setName(this.getName());
        return edit;
    }
}

