/*
 * Decompiled with CFR 0.152.
 */
package de.miethxml.toolkit.repository.ui.editor;

import de.miethxml.hawron.ApplicationConstants;
import de.miethxml.hawron.xml.SAXExternalEditorBuilder;
import de.miethxml.hawron.xml.XMLExternalEditorWriter;
import de.miethxml.toolkit.repository.ui.editor.ExternalEditor;
import java.io.File;
import java.util.ArrayList;

public class ExternalEditorManager {
    public static String CONFIGFILE = "conf" + File.separator + "editors.xml";
    private ArrayList editors = new ArrayList();
    private String userConfig;

    public void initialize() {
        File f = new File(String.valueOf(ApplicationConstants.USER_CONFIG_HOME) + File.separator + CONFIGFILE);
        if (f.exists()) {
            this.load(f);
        } else {
            this.load(new File(CONFIGFILE));
        }
    }

    public int getEditorCount() {
        return this.editors.size();
    }

    public void addEditor(ExternalEditor editor) {
        this.editors.add(editor);
        this.save();
    }

    public ExternalEditor getEditor(int index) {
        return (ExternalEditor)this.editors.get(index);
    }

    public void removeEditor(int index) {
        this.editors.remove(index);
        this.save();
    }

    private void load(File file) {
        if (file.exists() && file.isFile()) {
            SAXExternalEditorBuilder parser = new SAXExternalEditorBuilder();
            this.editors = parser.build(file.getAbsolutePath());
        }
    }

    public void save() {
        String config;
        XMLExternalEditorWriter writer = new XMLExternalEditorWriter();
        File f = new File(ApplicationConstants.USER_CONFIG_HOME);
        if (f.exists()) {
            config = String.valueOf(f.getAbsolutePath()) + File.separator + CONFIGFILE;
            File dir = new File(config);
            if (!dir.getParentFile().exists()) {
                dir.getParentFile().mkdir();
            }
        } else {
            config = CONFIGFILE;
        }
        writer.write(this.editors, config);
    }
}

