/*
 * Decompiled with CFR 0.152.
 */
package de.miethxml.toolkit.repository.ui.viewer;

import de.miethxml.toolkit.conf.ConfigManager;
import de.miethxml.toolkit.io.FileModel;
import de.miethxml.toolkit.repository.Reloadable;
import de.miethxml.toolkit.repository.RepositoryModel;
import de.miethxml.toolkit.repository.RepositorySelectionListener;
import de.miethxml.toolkit.repository.ui.viewer.CacheableViewer;
import de.miethxml.toolkit.repository.ui.viewer.RepositoryStreamViewer;
import de.miethxml.toolkit.repository.ui.viewer.RepositoryViewer;
import de.miethxml.toolkit.repository.ui.viewer.ViewerCloseListener;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;

public class ViewerAction
extends AbstractAction
implements ViewerCloseListener,
RepositorySelectionListener {
    private RepositoryViewer viewer;
    private ArrayList active;
    private ArrayList viewercache;
    private ArrayList closedViewers;
    private int CACHESIZE = 5;
    private boolean directorySelected;
    private String selectedPath;
    private Reloadable model;
    private boolean cacheable = false;
    private boolean selfdestroy = false;
    private boolean checksupportedextensions = true;
    private boolean streamViewer = false;
    private FileModel fileModel;

    public ViewerAction(RepositoryViewer viewer) {
        super(viewer.getToolTip(ConfigManager.getInstance().getProperty("lang")), viewer.getIcon());
        this.putValue("ShortDescription", viewer.getToolTip(ConfigManager.getInstance().getProperty("lang")));
        this.viewer = viewer;
        this.viewercache = new ArrayList();
        this.active = new ArrayList();
        this.closedViewers = new ArrayList();
        if (viewer instanceof CacheableViewer) {
            this.active = new ArrayList();
            this.viewercache.add(viewer);
            this.cacheable = true;
        } else {
            this.cacheable = false;
        }
        this.setEnabled(false);
        if (viewer instanceof RepositoryStreamViewer) {
            this.streamViewer = true;
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (this.cacheable) {
            this.viewer = this.viewercache.size() > 0 ? (RepositoryViewer)this.viewercache.remove(this.viewercache.size() - 1) : this.viewer.createNewViewer();
            this.active.add(this.viewer);
        } else {
            this.viewer = this.viewer.createNewViewer();
        }
        if (this.viewer != null) {
            Runnable r = new Runnable(){

                public void run() {
                    if (!ViewerAction.this.directorySelected) {
                        if (ViewerAction.this.streamViewer) {
                            ((RepositoryStreamViewer)((Object)ViewerAction.this.viewer)).open(ViewerAction.this.fileModel);
                        } else {
                            ViewerAction.this.viewer.open(ViewerAction.this.selectedPath);
                        }
                    }
                    ViewerAction.this.viewer.setVisible(true);
                }
            };
            Thread t = new Thread(r);
            t.start();
        }
    }

    public void close(CacheableViewer viewer) {
        if (!this.selfdestroy) {
            this.active.remove(viewer);
            if (this.viewercache.size() < this.CACHESIZE - 1) {
                this.viewercache.add(viewer);
                this.closedViewers.add(viewer);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ViewerAction.this.removeListener();
                    }
                });
            } else {
                viewer = null;
            }
        }
    }

    public void directorySelected(Reloadable model, FileModel directory) {
        this.selectedPath = directory.getPath();
        this.model = model;
        this.directorySelected = true;
        this.setEnabled(false);
    }

    public void fileSelected(Reloadable model, FileModel file) {
        this.selectedPath = file.getPath();
        this.model = model;
        this.fileModel = file;
        this.directorySelected = false;
        if (!this.viewer.isSupported(this.selectedPath) && this.checksupportedextensions) {
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
        }
    }

    public void setFileSystemModel(RepositoryModel model) {
        model.addRepositorySelectionListener(this);
    }

    public void destroy() {
        CacheableViewer cacheable;
        RepositoryViewer view;
        this.selfdestroy = true;
        Iterator i = this.viewercache.iterator();
        while (i.hasNext()) {
            view = (RepositoryViewer)i.next();
            if (view instanceof CacheableViewer) {
                cacheable = (CacheableViewer)view;
                cacheable.destroy();
            }
            i.remove();
        }
        i = this.active.iterator();
        while (i.hasNext()) {
            view = (RepositoryViewer)i.next();
            if (!(view instanceof CacheableViewer)) continue;
            cacheable = (CacheableViewer)view;
            cacheable.destroy();
        }
    }

    public void unselect() {
        this.setEnabled(false);
    }

    private void removeListener() {
        Iterator i = this.closedViewers.iterator();
        while (i.hasNext()) {
            CacheableViewer view = (CacheableViewer)i.next();
            view.removeViewerCloseListener(this);
            i.remove();
        }
    }

    public void setCheckSupportedExtensions(boolean check) {
        this.checksupportedextensions = check;
        if (!check) {
            this.setEnabled(true);
        }
    }
}

