/*
 * Decompiled with CFR 0.152.
 */
package de.miethxml.toolkit.setup.ui;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.miethxml.toolkit.conf.LocaleImpl;
import de.miethxml.toolkit.conf.LocaleListener;
import de.miethxml.toolkit.gui.LocaleButton;
import de.miethxml.toolkit.setup.ApplicationSetup;
import de.miethxml.toolkit.setup.SetupNode;
import de.miethxml.toolkit.setup.ui.ConfigDialog;
import de.miethxml.toolkit.ui.GradientLabel;
import de.miethxml.toolkit.ui.PanelFactory;
import de.miethxml.toolkit.ui.SmallShadowBorder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class ConfigDialogImpl
implements ActionListener,
Serviceable,
Initializable,
TreeSelectionListener,
LocaleListener,
ConfigDialog,
Disposable {
    private ServiceManager manager;
    private Hashtable guiconfigurables = new Hashtable();
    private JPanel setuppanel;
    private ApplicationSetup treemodel;
    private JTree setuptree;
    private JDialog dialog;

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
    }

    public void initialize() {
        this.dialog = new JDialog();
        this.dialog.setTitle(LocaleImpl.getInstance().getString("dialog.config.title"));
        LocaleImpl.getInstance().addLocaleListener(this);
        this.dialog.setTitle(LocaleImpl.getInstance().getString("dialog.config.title"));
        this.dialog.getContentPane().setLayout(new BorderLayout());
        FormLayout layout = new FormLayout("3dlu,pref:grow,3dlu", "3dlu,fill:p:grow,3dlu");
        PanelBuilder builder = new PanelBuilder(layout);
        CellConstraints cc = new CellConstraints();
        JSplitPane sp = PanelFactory.createDefaultSplitPane();
        sp.setDividerLocation(175);
        sp.setDividerSize(10);
        try {
            this.treemodel = (ApplicationSetup)this.manager.lookup(ApplicationSetup.ROLE);
        }
        catch (ServiceException se) {
            se.printStackTrace();
        }
        this.setuptree = new JTree(this.treemodel);
        this.setuptree.addTreeSelectionListener(this);
        this.setuptree.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        JScrollPane scroll = new JScrollPane(this.setuptree);
        scroll.setBorder(new SmallShadowBorder());
        sp.setLeftComponent(scroll);
        this.setuppanel = new JPanel(new BorderLayout());
        this.setuppanel.setPreferredSize(new Dimension(400, 300));
        scroll = new JScrollPane(this.setuppanel);
        scroll.setBorder(new SmallShadowBorder());
        sp.setRightComponent(scroll);
        sp.setPreferredSize(sp.getPreferredSize());
        builder.add((Component)sp, cc.xy(2, 2));
        JPanel setupPanel = builder.getPanel();
        this.dialog.getContentPane().add((Component)setupPanel, "Center");
        JButton[] buttons = new LocaleButton[2];
        buttons[0] = new LocaleButton("common.button.cancel");
        buttons[0].setActionCommand("cancel");
        buttons[0].addActionListener(this);
        buttons[1] = new LocaleButton("common.button.ok");
        buttons[1].setActionCommand("ok");
        buttons[1].addActionListener(this);
        LocaleButton button = new LocaleButton("common.button.help");
        button.setActionCommand("help");
        button.addActionListener(this);
        ButtonBarBuilder bbuilder = new ButtonBarBuilder();
        bbuilder.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        bbuilder.addGridded((JComponent)button);
        bbuilder.addRelatedGap();
        bbuilder.addGlue();
        bbuilder.addGriddedButtons(buttons);
        GradientLabel titleLabel = new GradientLabel("Preferences");
        titleLabel.setFontHeight(28);
        titleLabel.setStartColor(Color.GRAY);
        titleLabel.setEndColor(Color.WHITE);
        titleLabel.setTextColor(Color.BLACK);
        this.dialog.getContentPane().add((Component)titleLabel, "North");
        JPanel panel = bbuilder.getPanel();
        this.dialog.getContentPane().add((Component)panel, "South");
        this.dialog.setSize(640, 540);
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals("ok")) {
            this.setupAll();
            this.updateGui();
            this.dialog.dispose();
        } else if (command.equals("cancel")) {
            this.dialog.dispose();
        }
    }

    private void setupAll() {
        this.treemodel.setupNodes();
    }

    public void valueChanged(TreeSelectionEvent e) {
        TreePath tp = e.getPath();
        SetupNode node = (SetupNode)tp.getLastPathComponent();
        this.setuppanel.removeAll();
        if (node.hasGuiConfigurable()) {
            JComponent comp = node.getGuiConfigurable().getSetupComponent();
            this.setuppanel.add((Component)comp, "Center");
            this.setuppanel.setPreferredSize(comp.getPreferredSize());
        }
        this.setuppanel.validate();
        this.setuppanel.repaint();
    }

    public void setVisible(boolean state) {
        if (this.setuptree.getRowCount() > 0) {
            this.setuptree.expandRow(this.setuptree.getRowCount() - 1);
        }
        this.dialog.setVisible(state);
    }

    private void updateGui() {
    }

    private void validateSettings() {
    }

    public void langChanged() {
        this.dialog.setTitle(LocaleImpl.getInstance().getString("dialog.config.title"));
    }

    public void dispose() {
    }
}

