/*
 * Decompiled with CFR 0.152.
 */
package de.miethxml.toolkit.ui;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JComponent;

public class MemoryUsageComponent
extends JComponent {
    private long totalSize;
    private long currentSize;
    private double warningSize = 1.0;
    private int margin = 1;
    private AlphaComposite ac = AlphaComposite.getInstance(10, 0.4f);
    private StringBuffer text = new StringBuffer();

    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        int w = this.getWidth() - 2 * this.margin - 2;
        int h = this.getHeight() - 2 * this.margin - 1;
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        double p = (double)this.currentSize / (double)this.totalSize;
        int x = (int)(p * (double)w);
        this.text.delete(0, this.text.length());
        this.text.append((int)(this.currentSize / 0x100000L));
        this.text.append('/');
        this.text.append((int)(this.totalSize / 0x100000L));
        this.text.append("MB");
        FontMetrics fm = g2.getFontMetrics();
        String t = this.text.toString();
        int l = fm.stringWidth(t);
        g2.setColor(Color.BLACK);
        g2.drawString(t, (this.getWidth() - l) / 2, (this.getHeight() + fm.getHeight()) / 2 - fm.getDescent());
        g2.setComposite(this.ac);
        if (p >= this.warningSize) {
            g.setColor(Color.RED);
        } else {
            g.setColor(Color.GRAY);
        }
        g2.fillRect(this.margin, this.margin, x, h);
        g2.setColor(Color.BLACK);
        g2.drawRect(this.margin, this.margin, w, h);
    }

    public void setCurrentSize(long size) {
        this.currentSize = size;
        this.setToolTipText("Memory:" + size * 100L / this.totalSize + "%");
        this.repaint();
    }

    public void setTotalSize(long size) {
        this.totalSize = size;
    }
}

