/*
 * Decompiled with CFR 0.152.
 */
package de.miethxml.toolkit.wizard.component;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.miethxml.toolkit.wizard.component.AbstractWizardComponent;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class FileChooserComponent
extends AbstractWizardComponent {
    public static String STORE_KEY = "file.selected";
    private JTextField path;
    private JFileChooser chooser;

    public String getTitle() {
        return this.resource.getString("wizard.component.filechooser.title");
    }

    public JComponent getInstallUIComponent() {
        FormLayout layout = new FormLayout("9dlu,pref:grow,2dlu,pref,9dlu", "9dlu,pref,3dlu,pref,9dlu");
        PanelBuilder builder = new PanelBuilder(layout);
        CellConstraints cc = new CellConstraints();
        JEditorPane text = new JEditorPane();
        text.setContentType("text/html");
        text.setText(this.resource.getString("wizard.component.filechooser.desription"));
        text.setEditable(false);
        text.setOpaque(false);
        builder.add((Component)text, cc.xywh(2, 2, 3, 1));
        this.path = new JTextField(20);
        builder.add((Component)this.path, cc.xy(2, 4));
        this.chooser = new JFileChooser();
        this.chooser.setFileSelectionMode(2);
        this.chooser.setFileFilter(new FileFilter(){

            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String name = f.getName();
                return name.endsWith(".tar.gz") || name.endsWith(".zip");
            }

            public String getDescription() {
                return "";
            }
        });
        JButton button = new JButton(this.resource.getString("wizard.component.filechooser.choosebutton"));
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int value = FileChooserComponent.this.chooser.showDialog(null, FileChooserComponent.this.resource.getString("wizard.component.filechooser.choose"));
                if (value == 0) {
                    FileChooserComponent.this.path.setText(FileChooserComponent.this.chooser.getSelectedFile().getPath());
                }
            }
        });
        builder.add((Component)button, cc.xy(4, 4));
        return builder.getPanel();
    }

    public void startWizardProcess() {
        File f = new File(this.path.getText());
        this.conf.setValue(STORE_KEY, f.getAbsolutePath());
    }

    public void stopWizardProcess() {
    }

    public boolean isModifiable() {
        return true;
    }

    public void setup(Hashtable parameters) {
        System.out.println("setup Xhoo");
        if (parameters.containsKey("key")) {
            STORE_KEY = (String)parameters.get("key");
            System.out.println("setSTORE_KEY:" + STORE_KEY);
        }
    }
}

