/*
 * Decompiled with CFR 0.152.
 */
package de.miethxml.toolkit.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;
import javax.swing.border.Border;

public class PopupFineBorder
implements Border {
    private Insets i;
    private Color startColor;
    private Color endColor;
    final int steps = 55;
    private Color[] gradient;
    private String label;
    private String icon;
    private Image iconImg;
    private Image popupIcon;
    private int iconHeight = 16;
    private int iconWidth = 16;
    private double plainsize = 0.4;
    private boolean withicon;
    private Color textColor = Color.WHITE;
    private Color darkGray = new Color(100, 100, 100);
    private Color lightGray = new Color(160, 160, 160);
    private Component component;
    private boolean initialized = false;
    private JPopupMenu popupmenu;
    private String menuIcon = "icons/view_menu.gif";

    public PopupFineBorder(String title, JPopupMenu menu) {
        this.i = new Insets(25, 1, 3, 3);
        this.startColor = new Color(91, 110, 179);
        this.endColor = new Color(212, 212, 185);
        this.gradient = new Color[55];
        this.buildGradient();
        this.label = title;
        this.popupIcon = Toolkit.getDefaultToolkit().getImage(this.menuIcon);
        this.withicon = false;
        this.popupmenu = menu;
    }

    public PopupFineBorder(JPopupMenu menu) {
        this("", menu);
    }

    public Insets getBorderInsets(Component c) {
        return this.i;
    }

    public boolean isBorderOpaque() {
        return true;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        if (!this.initialized) {
            this.initialize(c);
        }
        FontMetrics fm = g.getFontMetrics();
        g.setColor(this.startColor);
        int size = (int)(this.plainsize * (double)(width - 2));
        g.fillRect(x + 1, y, size, y + this.i.top);
        this.paintGradient(g, x + 1 + size, y, width - 2 - size, this.i.top - 1);
        g.setColor(this.darkGray);
        g.drawLine(x + width - 3, y, x + width - 3, y + height);
        g.setColor(this.lightGray);
        g.drawLine(x + width - 2, y + 1, x + width - 2, y + height - 1);
        g.drawLine(x + width - 1, y + 2, x + width - 1, y + height - 2);
        g.setColor(this.darkGray);
        g.drawLine(x, y + height - 3, x + width - 3, y + height - 3);
        g.setColor(this.lightGray);
        g.drawLine(x + 1, y + height - 2, x + width - 2, y + height - 2);
        g.drawLine(x + 2, y + height - 1, x + width - 3, y + height - 1);
        g.setColor(Color.gray);
        g.drawLine(x, y, x, y + height - 3);
        g.setColor(Color.gray);
        g.drawLine(x, y, x + width - 5, y);
        g.drawLine(x, y + this.i.top - 1, x + width - this.i.right, y + this.i.top - 1);
        g.setColor(Color.white);
        g.drawLine(x + 1, y + 1, x + width - this.i.right - 1, y + 1);
        g.drawLine(x + 1, y + 1, x + 1, y + this.i.top - 1);
        if (this.withicon) {
            g.drawImage(this.iconImg, x + 5, y + (this.i.top - 1 - this.iconHeight) / 2, this.iconWidth, this.iconHeight, null);
            g.setColor(this.textColor);
            g.drawString(this.label, x + 10 + this.iconWidth, y + this.i.top / 2 + fm.getHeight() / 2);
        } else {
            g.setColor(this.textColor);
            g.drawString(this.label, x + 10, y + this.i.top / 2 + fm.getHeight() / 2);
        }
        g.drawImage(this.popupIcon, x + width - 20, 3, 16, 16, null);
    }

    private void paintGradient(Graphics g, int x, int y, int width, int height) {
        int i;
        double diffx = width / 55;
        int length = (int)diffx;
        for (i = 0; (i + 1) * length < width && i < 55; ++i) {
            g.setColor(this.gradient[i]);
            g.fillRect(x + i * length, y, length, height);
        }
        if (i < 55) {
            g.setColor(this.gradient[i]);
        } else {
            g.setColor(this.endColor);
        }
        g.fillRect(x + i * length, y, width - i * length, height);
    }

    private void buildGradient() {
        double diffred = this.endColor.getRed() - this.startColor.getRed();
        double diffgreen = this.endColor.getGreen() - this.startColor.getGreen();
        double diffblue = this.endColor.getBlue() - this.startColor.getBlue();
        this.gradient[0] = this.startColor;
        this.gradient[54] = this.endColor;
        for (int i = 1; i < 54; ++i) {
            this.gradient[i] = new Color(this.startColor.getRed() + (int)(diffred / 53.0 * (double)i), this.startColor.getGreen() + (int)(diffgreen / 53.0 * (double)i), this.startColor.getBlue() + (int)(diffblue / 53.0 * (double)i));
        }
    }

    public Color getEndColor() {
        return this.endColor;
    }

    public void setEndColor(Color endColor) {
        this.endColor = endColor;
        this.buildGradient();
    }

    public Color getStartColor() {
        return this.startColor;
    }

    public void setStartColor(Color startColor) {
        this.startColor = startColor;
        this.buildGradient();
    }

    public void setTitle(String title) {
        this.label = title;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color textColor) {
        this.textColor = textColor;
    }

    private void initialize(Component c) {
        this.component = c;
        c.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            public void mouseReleased(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            private void maybeShowPopup(MouseEvent e) {
                if (e.getButton() == 1 && e.getY() < PopupFineBorder.this.component.getY() + ((PopupFineBorder)PopupFineBorder.this).i.top) {
                    int right = PopupFineBorder.this.component.getX() + PopupFineBorder.this.component.getWidth() - 20;
                    if (e.getX() > right && e.getX() < right + 16) {
                        PopupFineBorder.this.popupmenu.show(PopupFineBorder.this.component, PopupFineBorder.this.component.getX() + PopupFineBorder.this.component.getWidth() - 20, PopupFineBorder.this.component.getY() + ((PopupFineBorder)PopupFineBorder.this).i.top - 1);
                    }
                }
            }
        });
        this.initialized = true;
    }
}

