/*
 * Decompiled with CFR 0.152.
 */
package de.miethxml.toolkit.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JComponent;

public class TitledLabel
extends JComponent {
    private static final int FONT_SIZE = 38;
    private String text = "";
    private Font font;
    private Color background;
    private Color foreground;
    private Dimension dim;
    private int padding = 20;
    private int fontHeight = 38;
    private int textLength = 0;
    private int margin = 4;

    public TitledLabel() {
        this("");
    }

    public TitledLabel(String text) {
        this(text, 38);
    }

    public TitledLabel(String text, int fontSize) {
        this.text = text;
        this.fontHeight = fontSize;
        this.init();
        this.generateLayout();
    }

    public void init() {
        this.font = new Font("SansSerif", 1, this.fontHeight);
        this.background = new Color(10, 10, 70);
        this.foreground = new Color(250, 250, 250);
    }

    private void generateLayout() {
        FontMetrics fm = this.getFontMetrics(this.font);
        this.fontHeight = fm.getHeight();
        this.textLength = fm.stringWidth(this.text);
        this.dim = new Dimension(this.padding * 2 + this.textLength + this.margin * 2, this.padding * 2 + this.fontHeight + this.margin * 2);
    }

    public Dimension getPreferredSize() {
        return this.dim;
    }

    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int width = this.getWidth();
        int height = this.getHeight();
        g2.setColor(this.background);
        g2.fillRoundRect(this.margin, this.margin, width - 1 - this.margin, height - 1 - this.margin, 7, 7);
        g2.setColor(this.foreground);
        g2.setFont(this.font);
        g2.drawString(this.text, this.margin + this.padding, this.margin + this.padding + this.fontHeight);
    }
}

