/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.dxf;

import org.kabeja.dxf.helpers.Point;

public class Bounds {
    protected double max_x = Double.NEGATIVE_INFINITY;
    protected double min_x = Double.POSITIVE_INFINITY;
    protected double max_y = Double.NEGATIVE_INFINITY;
    protected double min_y = Double.POSITIVE_INFINITY;
    protected double max_z = Double.NEGATIVE_INFINITY;
    protected double min_z = Double.POSITIVE_INFINITY;
    protected boolean set = true;

    public Bounds() {
    }

    public Bounds(double d, double d2, double d3, double d4, double d5, double d6) {
        this.max_x = d;
        this.min_x = d2;
        this.max_y = d3;
        this.min_y = d4;
        this.max_z = d5;
        this.min_z = d6;
    }

    public Bounds(double d, double d2, double d3, double d4) {
        this.max_x = d;
        this.min_x = d2;
        this.max_y = d3;
        this.min_y = d4;
    }

    public Bounds(Bounds bounds) {
        this.max_x = bounds.getMaximumX();
        this.min_x = bounds.getMinimumX();
        this.max_y = bounds.getMaximumY();
        this.min_y = bounds.getMinimumY();
        this.max_z = bounds.getMaximumZ();
        this.min_z = bounds.getMinimumZ();
    }

    public double getMaximumX() {
        return this.max_x;
    }

    public void setMaximumX(double d) {
        this.max_x = d;
    }

    public double getMaximumY() {
        return this.max_y;
    }

    public void setMaximumY(double d) {
        this.max_y = d;
    }

    public double getMinimumX() {
        return this.min_x;
    }

    public void setMinimumX(double d) {
        this.min_x = d;
    }

    public double getMinimumY() {
        return this.min_y;
    }

    public void setMinimumY(double d) {
        this.min_y = d;
    }

    public double getMinimumZ() {
        return this.min_z;
    }

    public void setMinimumZ(double d) {
        this.min_z = d;
    }

    public double getMaximumZ() {
        return this.max_z;
    }

    public void setMaximumZ(double d) {
        this.max_z = d;
    }

    public void addToBounds(Bounds bounds) {
        if (bounds.getMaximumX() > this.getMaximumX()) {
            this.setMaximumX(bounds.getMaximumX());
        }
        if (bounds.getMaximumY() > this.getMaximumY()) {
            this.setMaximumY(bounds.getMaximumY());
        }
        if (bounds.getMaximumZ() > this.getMaximumZ()) {
            this.setMaximumZ(bounds.getMaximumZ());
        }
        if (bounds.getMinimumX() < this.getMinimumX()) {
            this.setMinimumX(bounds.getMinimumX());
        }
        if (bounds.getMinimumY() < this.getMinimumY()) {
            this.setMinimumY(bounds.getMinimumY());
        }
        if (bounds.getMinimumZ() < this.getMinimumZ()) {
            this.setMinimumZ(bounds.getMinimumZ());
        }
    }

    public void addToBounds(double d, double d2, double d3) {
        if (d > this.getMaximumX()) {
            this.setMaximumX(d);
        }
        if (d < this.getMinimumX()) {
            this.setMinimumX(d);
        }
        if (d2 > this.getMaximumY()) {
            this.setMaximumY(d2);
        }
        if (d2 < this.getMinimumY()) {
            this.setMinimumY(d2);
        }
        if (d3 < this.getMinimumZ()) {
            this.setMinimumZ(d3);
        }
        if (d3 > this.getMaximumZ()) {
            this.setMaximumZ(d3);
        }
    }

    public void addToBounds(Point point) {
        this.addToBounds(point.getX(), point.getY(), point.getZ());
    }

    public double getWidth() {
        return Math.abs(this.getMaximumX() - this.getMinimumX());
    }

    public double getHeight() {
        return Math.abs(this.getMaximumY() - this.getMinimumY());
    }

    public double getDepth() {
        return Math.abs(this.getMaximumZ() - this.getMinimumZ());
    }

    public boolean isValid() {
        if (this.max_x == Double.NEGATIVE_INFINITY || this.max_y == Double.NEGATIVE_INFINITY || this.min_x == Double.POSITIVE_INFINITY || this.min_y == Double.POSITIVE_INFINITY) {
            return false;
        }
        return this.set;
    }

    public void setValid(boolean bl) {
        this.set = bl;
    }

    public void debug() {
        System.out.println("DEBUG Bounds");
        System.out.println("MAX_x=" + this.max_x);
        System.out.println("MAX_y=" + this.max_y);
        System.out.println("MIN_x=" + this.min_x);
        System.out.println("MIN_y=" + this.min_y);
        System.out.println("Width=" + this.getWidth() + " Height:" + this.getHeight());
    }

    public boolean contains(Bounds bounds) {
        if (bounds.getMaximumX() <= this.min_x || bounds.getMinimumX() >= this.max_x) {
            return false;
        }
        return !(bounds.getMaximumY() <= this.min_y) && !(bounds.getMinimumY() >= this.max_y);
    }

    public boolean contains(Point point) {
        return this.min_x <= point.getX() && this.max_x >= point.getX() && this.min_y <= point.getY() && this.max_y >= point.getY();
    }

    public boolean enclose(Bounds bounds) {
        return bounds.getMaximumX() <= this.max_x && bounds.getMinimumX() >= this.min_x && bounds.getMaximumY() <= this.max_y && bounds.getMinimumY() >= this.min_y;
    }
}

