/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.dxf;

import org.kabeja.dxf.Bounds;
import org.kabeja.dxf.DXFEntity;
import org.kabeja.dxf.helpers.Point;
import org.kabeja.math.ParametricPlane;

public class DXFCircle
extends DXFEntity {
    private Point center;
    private double radius;

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double d) {
        this.radius = d;
    }

    public void setCenterPoint(Point point) {
        this.center = point;
    }

    public Point getCenterPoint() {
        return this.center;
    }

    public Bounds getBounds() {
        Bounds bounds = new Bounds();
        ParametricPlane parametricPlane = new ParametricPlane(this.getExtrusion());
        Point point = parametricPlane.getPoint(this.center.getX(), this.center.getY());
        bounds.setMaximumX(point.getX() + this.radius);
        bounds.setMinimumX(point.getX() - this.radius);
        bounds.setMaximumY(point.getY() + this.radius);
        bounds.setMinimumY(point.getY() - this.radius);
        return bounds;
    }

    public String getType() {
        return "CIRCLE";
    }

    public double getLength() {
        return Math.PI * 2 * this.radius;
    }

    public Point getPointAt(double d) {
        double d2 = this.radius * Math.cos(Math.toRadians(d));
        double d3 = this.radius * Math.sin(Math.toRadians(d));
        ParametricPlane parametricPlane = new ParametricPlane(this.getExtrusion());
        Point point = parametricPlane.getPoint(d2 + this.center.getX(), d3 + this.center.getY());
        return point;
    }
}

