/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.dxf;

import org.kabeja.dxf.Bounds;
import org.kabeja.dxf.DXFBlock;
import org.kabeja.dxf.DXFEntity;
import org.kabeja.dxf.helpers.Point;

public class DXFInsert
extends DXFEntity {
    private Point insertPoint = new Point();
    private double scale_x = 1.0;
    private double scale_y = 1.0;
    private double scale_z = 1.0;
    private double rotate = 0.0;
    private int rows = 1;
    private int columns = 1;
    private double row_spacing = 0.0;
    private double column_spacing = 0.0;
    private String blockID = "";

    public Bounds getBounds() {
        Bounds bounds = new Bounds();
        DXFBlock dXFBlock = this.doc.getDXFBlock(this.getBlockID());
        Bounds bounds2 = dXFBlock.getBounds();
        if (!bounds2.isValid()) {
            bounds.setValid(false);
            return bounds;
        }
        Point point = dXFBlock.getReferencePoint();
        bounds.setMaximumX((bounds2.getMaximumX() - point.getX()) * this.scale_x);
        bounds.setMinimumX((bounds2.getMinimumX() - point.getX()) * this.scale_x);
        bounds.setMaximumY((bounds2.getMaximumY() - point.getY()) * this.scale_y);
        bounds.setMinimumY((bounds2.getMinimumY() - point.getY()) * this.scale_y);
        if (this.rotate != 0.0) {
            Point point2 = this.rotatePoint(bounds.getMaximumX(), bounds.getMaximumY());
            Point point3 = this.rotatePoint(bounds.getMaximumX(), bounds.getMinimumY());
            Point point4 = this.rotatePoint(bounds.getMinimumX(), bounds.getMaximumY());
            Point point5 = this.rotatePoint(bounds.getMinimumX(), bounds.getMinimumY());
            bounds = new Bounds();
            bounds.addToBounds(point2);
            bounds.addToBounds(point3);
            bounds.addToBounds(point4);
            bounds.addToBounds(point5);
        }
        bounds.setMaximumX(bounds.getMaximumX() + this.insertPoint.getX());
        bounds.setMinimumX(bounds.getMinimumX() + this.insertPoint.getX());
        bounds.setMaximumY(bounds.getMaximumY() + this.insertPoint.getY());
        bounds.setMinimumY(bounds.getMinimumY() + this.insertPoint.getY());
        double d = (double)(this.columns - 1) * this.column_spacing;
        double d2 = (double)(this.rows - 1) * this.row_spacing;
        if (d >= 0.0) {
            bounds.setMinimumX(bounds.getMinimumX() - d);
        } else {
            bounds.setMaximumX(bounds.getMaximumX() - d);
        }
        if (d2 >= 0.0) {
            bounds.setMinimumY(bounds.getMinimumY() - d2);
        } else {
            bounds.setMaximumY(bounds.getMaximumY() - d2);
        }
        return bounds;
    }

    public String getBlockID() {
        return this.blockID;
    }

    public void setBlockID(String string) {
        this.blockID = string;
    }

    public double getColumnSpacing() {
        return this.column_spacing;
    }

    public void setColumnSpacing(double d) {
        this.column_spacing = d;
    }

    public int getColumns() {
        return this.columns;
    }

    public void setColumns(int n) {
        this.columns = n;
    }

    public Point getPoint() {
        return this.insertPoint;
    }

    public void setPoint(Point point) {
        this.insertPoint = point;
    }

    public double getRotate() {
        return this.rotate;
    }

    public void setRotate(double d) {
        this.rotate = d;
    }

    public double getRowSpacing() {
        return this.row_spacing;
    }

    public void setRowSpacing(double d) {
        this.row_spacing = d;
    }

    public int getRows() {
        return this.rows;
    }

    public void setRows(int n) {
        this.rows = n;
    }

    public double getScaleX() {
        return this.scale_x;
    }

    public void setScaleX(double d) {
        this.scale_x = d;
    }

    public double getScaleY() {
        return this.scale_y;
    }

    public void setScaleY(double d) {
        this.scale_y = d;
    }

    public double getScaleZ() {
        return this.scale_z;
    }

    public void setScaleZ(double d) {
        this.scale_z = d;
    }

    private Point rotatePoint(double d, double d2) {
        double d3 = Math.toRadians(this.rotate);
        Point point = new Point();
        point.setX(d * Math.cos(d3) - d2 * Math.sin(d3));
        point.setY(d * Math.sin(d3) + d2 * Math.cos(d3));
        return point;
    }

    public String getType() {
        return "INSERT";
    }

    public double getLength() {
        return this.doc.getDXFBlock(this.blockID).getLength();
    }
}

