/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.dxf;

import java.util.ArrayList;
import java.util.List;
import org.kabeja.dxf.Bounds;
import org.kabeja.dxf.DXFEntity;
import org.kabeja.dxf.DXFPolyline;
import org.kabeja.dxf.helpers.DXFMLineSegment;
import org.kabeja.dxf.helpers.MLineConverter;
import org.kabeja.dxf.helpers.Point;

public class DXFMLine
extends DXFEntity {
    public static final int JUSTIFICATION_TOP = 0;
    public static final int JUSTIFICATION_ZERO = 1;
    public static final int JUSTIFICATION_BOTTOM = 2;
    protected double scale = 1.0;
    protected Point startPoint = new Point();
    protected List mlineSegments = new ArrayList();
    protected int lineCount = 0;
    protected int justification = 0;
    protected String mLineStyleID = "";
    protected String mLineStyleName = "";

    public Bounds getBounds() {
        Bounds bounds = new Bounds();
        DXFPolyline[] dXFPolylineArray = this.toDXFPolylines();
        for (int i = 0; i < dXFPolylineArray.length; ++i) {
            bounds.addToBounds(dXFPolylineArray[i].getBounds());
        }
        return bounds;
    }

    public String getType() {
        return "MLINE";
    }

    public double getLength() {
        DXFPolyline[] dXFPolylineArray = this.toDXFPolylines();
        double d = 0.0;
        for (int i = 0; i < dXFPolylineArray.length; ++i) {
            d += dXFPolylineArray[i].getLength();
        }
        return d;
    }

    public void addDXFMLineSegement(DXFMLineSegment dXFMLineSegment) {
        this.mlineSegments.add(dXFMLineSegment);
    }

    public int getDXFMLineSegmentCount() {
        return this.mlineSegments.size();
    }

    public DXFMLineSegment getDXFMLineSegment(int n) {
        return (DXFMLineSegment)this.mlineSegments.get(n);
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double d) {
        this.scale = d;
    }

    public Point getStartPoint() {
        return this.startPoint;
    }

    public void setStartPoint(Point point) {
        this.startPoint = point;
    }

    public int getLineCount() {
        return this.lineCount;
    }

    public void setLineCount(int n) {
        this.lineCount = n;
    }

    public String getMLineStyleID() {
        return this.mLineStyleID;
    }

    public void setMLineStyleID(String string) {
        this.mLineStyleID = string;
    }

    public int getJustification() {
        return this.justification;
    }

    public void setJustification(int n) {
        this.justification = n;
    }

    public String getMLineStyleName() {
        return this.mLineStyleName;
    }

    public void setMLineStyleName(String string) {
        this.mLineStyleName = string;
    }

    protected DXFPolyline[] toDXFPolylines() {
        return MLineConverter.toDXFPolyline(this);
    }

    public boolean isClosed() {
        return (this.flags & 2) == 2;
    }
}

