/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.dxf;

import java.util.ArrayList;
import java.util.Iterator;
import org.kabeja.dxf.Bounds;
import org.kabeja.dxf.DXFEntity;
import org.kabeja.dxf.DXFPoint;
import org.kabeja.dxf.DXFVertex;
import org.kabeja.dxf.helpers.Point;
import org.kabeja.dxf.helpers.Vector;
import org.kabeja.math.MathUtils;

public class DXFPolyline
extends DXFEntity {
    protected static final double QUARTER_CIRCLE_ANGLE = Math.tan(0.39269908169872414);
    protected ArrayList vertices = new ArrayList();
    protected double startWidth = 0.0;
    protected double endWidth = 0.0;
    protected boolean constantWidth = true;
    protected int surefaceType = 0;
    protected int surefaceDensityRows = 0;
    protected int surefaceDensityColumns = 0;
    protected int rows = 0;
    protected int columns = 0;

    public Bounds getBounds() {
        Bounds bounds = new Bounds();
        Iterator iterator = this.vertices.iterator();
        if (iterator.hasNext()) {
            DXFVertex dXFVertex;
            DXFVertex dXFVertex2 = null;
            DXFVertex dXFVertex3 = dXFVertex = (DXFVertex)iterator.next();
            bounds.addToBounds(dXFVertex3.getPoint());
            while (iterator.hasNext()) {
                dXFVertex2 = (DXFVertex)iterator.next();
                this.addToBounds(dXFVertex3, dXFVertex2, bounds);
                dXFVertex3 = dXFVertex2;
            }
            if (dXFVertex2 != null && dXFVertex2.getBulge() != 0.0) {
                this.addToBounds(dXFVertex2, dXFVertex, bounds);
            }
        } else {
            bounds.setValid(false);
        }
        return bounds;
    }

    public void addVertex(DXFVertex dXFVertex) {
        this.vertices.add(dXFVertex);
        if (!dXFVertex.isConstantWidth()) {
            this.constantWidth = false;
        }
    }

    public int getVertexCount() {
        return this.vertices.size();
    }

    public Iterator getVertexIterator() {
        return this.vertices.iterator();
    }

    public void removeVertex(DXFVertex dXFVertex) {
        this.constantWidth = true;
        Iterator iterator = this.vertices.iterator();
        while (iterator.hasNext()) {
            DXFVertex dXFVertex2 = (DXFVertex)iterator.next();
            if (dXFVertex2 == dXFVertex) {
                iterator.remove();
                continue;
            }
            if (dXFVertex2.isConstantWidth()) continue;
            this.constantWidth = false;
        }
    }

    public void removeVertex(int n) {
        this.constantWidth = true;
        for (int i = 0; i < this.vertices.size(); ++i) {
            DXFVertex dXFVertex = (DXFVertex)this.vertices.get(i);
            if (n == i) {
                this.vertices.remove(i);
                continue;
            }
            if (dXFVertex.isConstantWidth()) continue;
            this.constantWidth = false;
        }
    }

    public DXFVertex getVertex(int n) {
        return (DXFVertex)this.vertices.get(n);
    }

    protected double getLength(DXFPoint dXFPoint, DXFPoint dXFPoint2) {
        double d = Math.sqrt(Math.pow(dXFPoint2.getX() - dXFPoint.getX(), 2.0) + Math.pow(dXFPoint2.getY() - dXFPoint.getY(), 2.0));
        return d;
    }

    public double getRadius(double d, double d2) {
        double d3 = d * d2 / 2.0;
        double d4 = d3 / 2.0 + Math.pow(d2, 2.0) / (8.0 * d3);
        return Math.abs(d4);
    }

    public String getType() {
        return "POLYLINE";
    }

    public double getEndWidth() {
        return this.endWidth;
    }

    public void setEndWidth(double d) {
        this.endWidth = d;
    }

    public double getStartWidth() {
        return this.startWidth;
    }

    public void setStartWidth(double d) {
        this.startWidth = d;
    }

    public boolean isClosed() {
        return (this.flags & 1) == 1;
    }

    public boolean isCurveFitVerticesAdded() {
        return (this.flags & 2) == 2;
    }

    public boolean isSplineFitVerticesAdded() {
        return (this.flags & 4) == 4;
    }

    public boolean is3DPolygon() {
        return (this.flags & 8) == 8;
    }

    public boolean is3DPolygonMesh() {
        return (this.flags & 0x10) == 16;
    }

    public boolean isPolyfaceMesh() {
        return (this.flags & 0x40) == 64;
    }

    public boolean isClosedMeshNDirection() {
        return (this.flags & 0x20) == 32;
    }

    public boolean isClosedMeshMDirection() {
        return (this.flags & 1) == 1;
    }

    public boolean isQuadSpline() {
        if (this.isSplineFitVerticesAdded()) {
            return this.surefaceType == 5;
        }
        return false;
    }

    public boolean isCubicSpline() {
        if (this.isSplineFitVerticesAdded()) {
            return this.surefaceType == 6;
        }
        return false;
    }

    public boolean isConstantWidth() {
        if (!this.constantWidth) {
            return false;
        }
        this.constantWidth = true;
        Iterator iterator = this.vertices.iterator();
        while (iterator.hasNext()) {
            DXFVertex dXFVertex = (DXFVertex)iterator.next();
            if (dXFVertex.isConstantWidth()) continue;
            this.constantWidth = false;
            return this.constantWidth;
        }
        return this.constantWidth;
    }

    public int getSurefaceType() {
        return this.surefaceType;
    }

    public void setSurefaceType(int n) {
        this.surefaceType = n;
    }

    public int getSurefaceDensityColumns() {
        return this.surefaceDensityColumns;
    }

    public void setSurefaceDensityColumns(int n) {
        this.surefaceDensityColumns = n;
    }

    public int getSurefaceDensityRows() {
        return this.surefaceDensityRows;
    }

    public void setSurefaceDensityRows(int n) {
        this.surefaceDensityRows = n;
    }

    protected void addToBounds(DXFVertex dXFVertex, DXFVertex dXFVertex2, Bounds bounds) {
        if (dXFVertex.getBulge() != 0.0) {
            double d;
            double d2 = MathUtils.distance(dXFVertex.getPoint(), dXFVertex2.getPoint());
            double d3 = this.getRadius(dXFVertex.getBulge(), d2);
            double d4 = d2 / 2.0;
            Vector vector = MathUtils.getVector(dXFVertex.getPoint(), dXFVertex2.getPoint());
            vector = MathUtils.normalize(vector);
            Point point = MathUtils.getPointOfStraightLine(dXFVertex.getPoint(), vector, d4);
            Vector vector2 = MathUtils.crossProduct(vector, this.getExtrusion().getNormal());
            vector2 = MathUtils.normalize(vector2);
            double d5 = Math.abs(dXFVertex.getBulge() * d2) / 2.0;
            int n = 0;
            int n2 = 0;
            double d6 = dXFVertex.getBulge();
            if (d6 > 0.0) {
                if (d6 > 1.0) {
                    d = d5 - d3;
                    point = MathUtils.getPointOfStraightLine(point, vector2, d);
                } else {
                    d = d3 - d5;
                    point = MathUtils.getPointOfStraightLine(point, vector2, -1.0 * d);
                }
                n2 = MathUtils.getQuadrant(dXFVertex2.getPoint(), point);
                n = MathUtils.getQuadrant(dXFVertex.getPoint(), point);
            } else {
                if (d6 < -1.0) {
                    d = d5 - d3;
                    point = MathUtils.getPointOfStraightLine(point, vector2, -1.0 * d);
                } else {
                    d = d3 - d5;
                    point = MathUtils.getPointOfStraightLine(point, vector2, d);
                }
                n = MathUtils.getQuadrant(dXFVertex2.getPoint(), point);
                n2 = MathUtils.getQuadrant(dXFVertex.getPoint(), point);
            }
            if (n2 < n) {
                n2 += 4;
            } else if (n2 == n && Math.abs(dXFVertex.getBulge()) > QUARTER_CIRCLE_ANGLE) {
                n2 += 4;
            }
            while (n2 > n) {
                switch (n) {
                    case 0: {
                        bounds.addToBounds(point.getX(), point.getY() + d3, point.getZ());
                        break;
                    }
                    case 1: {
                        bounds.addToBounds(point.getX() - d3, point.getY(), point.getZ());
                        break;
                    }
                    case 2: {
                        bounds.addToBounds(point.getX(), point.getY() - d3, point.getZ());
                        break;
                    }
                    case 3: {
                        bounds.addToBounds(point.getX() + d3, point.getY(), point.getZ());
                        n2 -= 4;
                        n -= 4;
                    }
                }
                ++n;
            }
        }
        bounds.addToBounds(dXFVertex.getPoint());
        bounds.addToBounds(dXFVertex2.getPoint());
    }

    public DXFVertex getPolyFaceMeshVertex(int n) {
        Iterator iterator = this.vertices.iterator();
        int n2 = 1;
        while (iterator.hasNext()) {
            DXFVertex dXFVertex = (DXFVertex)iterator.next();
            if (!dXFVertex.isPolyFaceMeshVertex()) continue;
            if (n2 == n) {
                return dXFVertex;
            }
            ++n2;
        }
        return null;
    }

    public int getColumns() {
        return this.columns;
    }

    public void setColumns(int n) {
        this.columns = n;
    }

    public int getRows() {
        return this.rows;
    }

    public void setRows(int n) {
        this.rows = n;
    }

    public boolean isSimpleMesh() {
        return this.surefaceType == 0 && (this.flags & 4) == 0;
    }

    public boolean isQuadSurefaceMesh() {
        return this.surefaceType == 5 && (this.flags & 4) == 4;
    }

    public boolean isCubicSurefaceMesh() {
        return this.surefaceType == 6 && (this.flags & 4) == 4;
    }

    public boolean isBezierSurefaceMesh() {
        return this.surefaceType == 8 && (this.flags & 4) == 4;
    }

    public double getLength() {
        DXFVertex dXFVertex;
        double d = 0.0;
        if (this.isCubicSpline() || this.isQuadSpline()) {
            return this.getSplineApproximationLength();
        }
        if (this.isPolyfaceMesh()) {
            return this.getPolyfaceLength();
        }
        if (this.is3DPolygonMesh() || this.isBezierSurefaceMesh() || this.isCubicSurefaceMesh()) {
            return this.getMeshLength();
        }
        Iterator iterator = this.vertices.iterator();
        DXFVertex dXFVertex2 = dXFVertex = (DXFVertex)iterator.next();
        while (iterator.hasNext()) {
            DXFVertex dXFVertex3 = (DXFVertex)iterator.next();
            d += this.getSegmentLength(dXFVertex2, dXFVertex3);
            dXFVertex2 = dXFVertex3;
        }
        if (this.isClosed()) {
            d += this.getSegmentLength(dXFVertex2, dXFVertex);
        }
        return d;
    }

    protected double getSegmentLength(DXFVertex dXFVertex, DXFVertex dXFVertex2) {
        double d = MathUtils.distance(dXFVertex.getPoint(), dXFVertex2.getPoint());
        if (dXFVertex.getBulge() == 0.0) {
            return d;
        }
        double d2 = 4.0 * Math.atan(Math.abs(dXFVertex.getBulge()));
        double d3 = d / (2.0 * Math.sin(d2 / 2.0));
        double d4 = Math.PI * Math.toDegrees(d2) * d3 / 180.0;
        return d4;
    }

    protected double getSplineApproximationLength() {
        double d = 0.0;
        Iterator iterator = this.vertices.iterator();
        DXFVertex dXFVertex = null;
        DXFVertex dXFVertex2 = null;
        while (iterator.hasNext()) {
            DXFVertex dXFVertex3 = (DXFVertex)iterator.next();
            if (!dXFVertex3.is2DSplineApproximationVertex()) continue;
            if (dXFVertex == null) {
                dXFVertex = dXFVertex2 = dXFVertex3;
                continue;
            }
            d += this.getSegmentLength(dXFVertex2, dXFVertex3);
            dXFVertex2 = dXFVertex3;
        }
        if (this.isClosed()) {
            d += this.getSegmentLength(dXFVertex2, dXFVertex);
        }
        return d;
    }

    protected double getPolyfaceLength() {
        double d = 0.0;
        Iterator iterator = this.vertices.iterator();
        while (iterator.hasNext()) {
            DXFVertex dXFVertex = (DXFVertex)iterator.next();
            if (!dXFVertex.isFaceRecord()) continue;
            DXFVertex dXFVertex2 = this.getPolyFaceMeshVertex(dXFVertex.getPolyFaceMeshVertex0());
            DXFVertex dXFVertex3 = this.getPolyFaceMeshVertex(dXFVertex.getPolyFaceMeshVertex1());
            DXFVertex dXFVertex4 = this.getPolyFaceMeshVertex(dXFVertex.getPolyFaceMeshVertex2());
            DXFVertex dXFVertex5 = this.getPolyFaceMeshVertex(dXFVertex.getPolyFaceMeshVertex3());
            if (dXFVertex.isPolyFaceEdge0Visible() && dXFVertex.getPolyFaceMeshVertex0() != 0) {
                d += this.getSegmentLength(dXFVertex2, dXFVertex3);
            }
            if (dXFVertex.isPolyFaceEdge1Visible() && dXFVertex.getPolyFaceMeshVertex1() != 0) {
                d += this.getSegmentLength(dXFVertex3, dXFVertex4);
            }
            if (dXFVertex.isPolyFaceEdge2Visible() && dXFVertex.getPolyFaceMeshVertex2() != 0) {
                d += this.getSegmentLength(dXFVertex4, dXFVertex5);
            }
            if (dXFVertex.isPolyFaceEdge3Visible() && dXFVertex.getPolyFaceMeshVertex3() != 0) {
                d += this.getSegmentLength(dXFVertex5, dXFVertex2);
                continue;
            }
            if (dXFVertex5 != null || dXFVertex4 == null) continue;
            d += this.getSegmentLength(dXFVertex4, dXFVertex2);
        }
        return d;
    }

    protected double getMeshLength() {
        double d = 0.0;
        if (this.isSimpleMesh()) {
            int n;
            int n2;
            DXFVertex[][] dXFVertexArray = new DXFVertex[this.rows][this.columns];
            Iterator iterator = this.vertices.iterator();
            for (n2 = 0; n2 < this.rows; ++n2) {
                for (n = 0; n < this.columns; ++n) {
                    DXFVertex dXFVertex;
                    dXFVertexArray[n2][n] = dXFVertex = (DXFVertex)iterator.next();
                    if (n <= 0) continue;
                    d += this.getSegmentLength(dXFVertexArray[n2][n - 1], dXFVertexArray[n2][n]);
                }
                if (!this.isClosedMeshNDirection()) continue;
                d += this.getSegmentLength(dXFVertexArray[n2][dXFVertexArray[n2].length - 1], dXFVertexArray[n2][0]);
            }
            for (n2 = 0; n2 < this.columns; ++n2) {
                for (n = 0; n < this.rows; ++n) {
                    if (n <= 0) continue;
                    d += this.getSegmentLength(dXFVertexArray[n - 1][n2], dXFVertexArray[n][n2]);
                }
                if (!this.isClosedMeshMDirection()) continue;
                d += this.getSegmentLength(dXFVertexArray[dXFVertexArray[n2].length - 1][n2], dXFVertexArray[0][n2]);
            }
        } else {
            int n;
            int n3;
            Object object;
            DXFVertex[][] dXFVertexArray = new DXFVertex[this.surefaceDensityRows][this.surefaceDensityColumns];
            Iterator iterator = this.vertices.iterator();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            while (iterator.hasNext()) {
                object = (DXFVertex)iterator.next();
                if (!((DXFVertex)object).isMeshApproximationVertex()) continue;
                arrayList.add(object);
            }
            object = arrayList.iterator();
            for (n3 = 0; n3 < this.surefaceDensityRows; ++n3) {
                for (n = 0; n < this.surefaceDensityColumns; ++n) {
                    DXFVertex dXFVertex;
                    dXFVertexArray[n3][n] = dXFVertex = (DXFVertex)object.next();
                    if (n <= 0) continue;
                    d += this.getSegmentLength(dXFVertexArray[n3][n - 1], dXFVertexArray[n3][n]);
                }
                if (!this.isClosedMeshNDirection()) continue;
                d += this.getSegmentLength(dXFVertexArray[n3][dXFVertexArray[n3].length - 1], dXFVertexArray[n3][0]);
            }
            for (n3 = 0; n3 < this.surefaceDensityColumns; ++n3) {
                for (n = 0; n < this.surefaceDensityRows; ++n) {
                    if (n <= 0) continue;
                    d += this.getSegmentLength(dXFVertexArray[n - 1][n3], dXFVertexArray[n][n3]);
                }
                if (!this.isClosedMeshMDirection()) continue;
                d += this.getSegmentLength(dXFVertexArray[dXFVertexArray[n3].length - 1][n3], dXFVertexArray[0][n3]);
            }
        }
        return d;
    }
}

