/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.dxf;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.kabeja.dxf.Bounds;
import org.kabeja.dxf.DXFConstants;
import org.kabeja.dxf.DXFEntity;
import org.kabeja.dxf.helpers.Point;
import org.kabeja.dxf.helpers.Vector;
import org.kabeja.math.MathUtils;
import org.kabeja.math.ParametricPlane;

public class DXFViewport
extends DXFEntity {
    private String viewportID = "";
    private String plotStyleName = "";
    private Point lowerLeftCorner = new Point();
    private Point upperRightCorner = new Point();
    private Point centerPoint = new Point();
    private Point snapBasePoint = new Point();
    private Point snapSpacingPoint = new Point();
    private Point gridSpacingPoint = new Point();
    private Vector viewDirectionVector = new Vector();
    private Point viewCenterPoint = new Point();
    private Point viewTargetPoint = new Point();
    private Vector ucsOrigin = new Vector();
    private Vector ucsXAxis = new Vector();
    private Vector ucsYAxis = new Vector();
    private int ucsType = 0;
    private int viewportStatus = 0;
    private double ucsElevation = 0.0;
    private boolean useUCS = false;
    private double height;
    private double width;
    private double ratio;
    private double lensLength;
    private double viewHeight;
    private double frontClippingPlane;
    private double backClippingPlane;
    private double twistAngle;
    private double snapAngle;
    private double circleZoom;
    private double fastZoom;
    private boolean snap;
    private boolean grid;
    private boolean active = false;
    private int renderMode;
    private Set frozenLayerSet = new HashSet();

    public double getBackClippingPlane() {
        return this.backClippingPlane;
    }

    public void setBackClippingPlane(double d) {
        this.backClippingPlane = d;
    }

    public Point getCenterPoint() {
        return this.centerPoint;
    }

    public void setCenterPoint(Point point) {
        this.centerPoint = point;
    }

    public double getCircleZoom() {
        return this.circleZoom;
    }

    public void setCircleZoom(double d) {
        this.circleZoom = d;
    }

    public double getFastZoom() {
        return this.fastZoom;
    }

    public void setFastZoom(double d) {
        this.fastZoom = d;
    }

    public double getFrontClippingPlane() {
        return this.frontClippingPlane;
    }

    public void setFrontClippingPlane(double d) {
        this.frontClippingPlane = d;
    }

    public boolean isGrid() {
        return this.grid;
    }

    public void setGrid(boolean bl) {
        this.grid = bl;
    }

    public Point getGridSpacingPoint() {
        return this.gridSpacingPoint;
    }

    public void setGridSpacingPoint(Point point) {
        this.gridSpacingPoint = point;
    }

    public double getHeight() {
        return this.height;
    }

    public void setHeight(double d) {
        this.height = d;
    }

    public double getLensLength() {
        return this.lensLength;
    }

    public void setLensLength(double d) {
        this.lensLength = d;
    }

    public Point getLowerLeftCorner() {
        return this.lowerLeftCorner;
    }

    public void setLowerLeftCorner(Point point) {
        this.lowerLeftCorner = point;
    }

    public String getViewportID() {
        return this.viewportID;
    }

    public void setViewportID(String string) {
        this.viewportID = string;
    }

    public double getAspectRatio() {
        return this.ratio;
    }

    public void setAspectRatio(double d) {
        this.ratio = d;
    }

    public void setTwistAngle(double d) {
        this.twistAngle = d;
    }

    public boolean isSnap() {
        return this.snap;
    }

    public void setSnap(boolean bl) {
        this.snap = bl;
    }

    public Point getSnapBasePoint() {
        return this.snapBasePoint;
    }

    public void setSnapBasePoint(Point point) {
        this.snapBasePoint = point;
    }

    public Point getUpperRightCorner() {
        return this.upperRightCorner;
    }

    public void setUpperRightCorner(Point point) {
        this.upperRightCorner = point;
    }

    public Vector getViewDirectionVector() {
        return this.viewDirectionVector;
    }

    public void setViewDirectionVector(Vector vector) {
        this.viewDirectionVector = vector;
    }

    public Point getViewCenterPoint() {
        return this.viewCenterPoint;
    }

    public void setViewCenterPoint(Point point) {
        this.viewCenterPoint = point;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean bl) {
        this.active = bl;
    }

    public Bounds getBounds() {
        Bounds bounds = new Bounds();
        if (this.viewportStatus > 0) {
            bounds.addToBounds(this.centerPoint.getX() - this.width / 2.0, this.centerPoint.getY() - this.height / 2.0, 0.0);
            bounds.addToBounds(this.centerPoint.getX() + this.width / 2.0, this.centerPoint.getY() + this.height / 2.0, 0.0);
        }
        return bounds;
    }

    public double getLength() {
        return 0.0;
    }

    public String getType() {
        return "VIEWPORT";
    }

    public double getWidth() {
        return this.width;
    }

    public void setWidth(double d) {
        this.width = d;
    }

    public void setRenderMode(int n) {
        this.renderMode = n;
    }

    public double getViewHeight() {
        return this.viewHeight;
    }

    public void setViewHeight(double d) {
        this.viewHeight = d;
    }

    public Vector getUcsOrigin() {
        return this.ucsOrigin;
    }

    public void setUcsOrigin(Vector vector) {
        this.ucsOrigin = vector;
    }

    public Vector getUcsXAxis() {
        return this.ucsXAxis;
    }

    public void setUcsXAxis(Vector vector) {
        this.ucsXAxis = vector;
    }

    public Vector getUcsYAxis() {
        return this.ucsYAxis;
    }

    public void setUcsYAxis(Vector vector) {
        this.ucsYAxis = vector;
    }

    public int getUcsType() {
        return this.ucsType;
    }

    public void setUcsType(int n) {
        this.ucsType = n;
    }

    public double getUcsElevation() {
        return this.ucsElevation;
    }

    public void setUcsElevation(double d) {
        this.ucsElevation = d;
    }

    public boolean isUseUCS() {
        return this.useUCS;
    }

    public void setUseUCS(boolean bl) {
        this.useUCS = bl;
    }

    public double getRatio() {
        return this.ratio;
    }

    public void setRatio(double d) {
        this.ratio = d;
    }

    public int getRenderMode() {
        return this.renderMode;
    }

    public double getSnapAngle() {
        return this.snapAngle;
    }

    public void setSnapAngle(double d) {
        this.snapAngle = d;
    }

    public Point getViewTargetPoint() {
        return this.viewTargetPoint;
    }

    public void setViewTargetPoint(Point point) {
        this.viewTargetPoint = point;
    }

    public Point getSnapSpacingPoint() {
        return this.snapSpacingPoint;
    }

    public void setSnapSpacingPoint(Point point) {
        this.snapSpacingPoint = point;
    }

    public String getPlotStyleName() {
        return this.plotStyleName;
    }

    public void setPlotStyleName(String string) {
        this.plotStyleName = string;
    }

    public int getViewportStatus() {
        return this.viewportStatus;
    }

    public void setViewportStatus(int n) {
        this.viewportStatus = n;
    }

    public double getTwistAngle() {
        return this.twistAngle;
    }

    public void addFrozenLayer(String string) {
        this.frozenLayerSet.add(string);
    }

    public boolean isFrozenLayer(String string) {
        return this.frozenLayerSet.contains(string);
    }

    public Iterator getFrozenLayerIterator() {
        return this.frozenLayerSet.iterator();
    }

    public double getZoomXPFactor() {
        if (this.viewHeight != 0.0) {
            return this.height / this.viewHeight;
        }
        return this.calculateZoomXPFactor();
    }

    public double calculateZoomXPFactor() {
        double d = this.getViewDirectionVector().getLength() * 42.0 / this.lensLength;
        double d2 = this.width / this.height;
        double d3 = Math.sqrt(Math.pow(d, 2.0) / (Math.pow(d2, 2.0) + 1.0));
        return this.height / d3;
    }

    public Bounds getModelspaceViewBounds() {
        double d = this.width / this.height;
        double d2 = this.height / this.getZoomXPFactor() / 2.0;
        double d3 = d * d2;
        double d4 = d3 / d2;
        Vector vector = null;
        vector = this.viewDirectionVector.getX() == 0.0 && this.viewDirectionVector.getY() == 0.0 && this.viewDirectionVector.getZ() == 1.0 ? new Vector(1.0, 0.0, 0.0) : MathUtils.crossProduct(DXFConstants.DEFAULT_Z_AXIS_VECTOR, this.viewDirectionVector);
        ParametricPlane parametricPlane = new ParametricPlane(this.viewTargetPoint, vector, MathUtils.crossProduct(this.viewDirectionVector, vector), this.viewDirectionVector);
        Bounds bounds = new Bounds();
        Point point = parametricPlane.getPoint(this.viewCenterPoint.getX() - d3, this.viewCenterPoint.getY() - d2);
        bounds.addToBounds(point);
        point = parametricPlane.getPoint(this.viewCenterPoint.getX() + d3, this.viewCenterPoint.getY() + d2);
        bounds.addToBounds(point);
        return bounds;
    }
}

