/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.dxf.helpers;

import java.util.ArrayList;
import org.kabeja.dxf.DXFLine;
import org.kabeja.dxf.DXFPolyline;
import org.kabeja.dxf.DXFVertex;
import org.kabeja.dxf.helpers.Point;
import org.kabeja.dxf.helpers.Vector;
import org.kabeja.math.MathUtils;

public class DXFUtils {
    public static double distance(Point point, Point point2) {
        double d = Math.sqrt(Math.pow(point2.getX() - point.getX(), 2.0) + Math.pow(point2.getY() - point.getY(), 2.0));
        return d;
    }

    public static double rotateAngleX(Point point, Point point2) {
        if (point2.getY() == point.getY()) {
            return 0.0;
        }
        double d = point2.getX() - point.getX();
        double d2 = point2.getY() - point.getY();
        return Math.toDegrees(Math.atan(1.0 / (d2 / d)));
    }

    public static double vectorValue(double[] dArray) {
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += dArray[i] * dArray[i];
        }
        return Math.sqrt(d);
    }

    public static Point scalePoint(Point point, double d) {
        Point point2 = new Point();
        point2.setX(point.getX() * d);
        point2.setY(point.getY() * d);
        point2.setZ(point.getZ() * d);
        return point2;
    }

    public static Point getPointFromParameterizedLine(Point point, Vector vector, double d) {
        Point point2 = DXFUtils.scalePoint(vector, d);
        point2.setX(point2.getX() + point.getX());
        point2.setY(point2.getY() + point.getY());
        point2.setZ(point2.getZ() + point.getZ());
        return point2;
    }

    public static void reverseDXFLine(DXFLine dXFLine) {
        Point point = dXFLine.getStartPoint();
        dXFLine.setStartPoint(dXFLine.getEndPoint());
        dXFLine.setEndPoint(point);
    }

    public static void reverseDXFPolyline(DXFPolyline dXFPolyline) {
        int n;
        ArrayList<DXFVertex> arrayList = new ArrayList<DXFVertex>();
        double d = 0.0;
        int n2 = dXFPolyline.getVertexCount();
        for (n = 0; n < n2; ++n) {
            DXFVertex dXFVertex = dXFPolyline.getVertex(0);
            double d2 = dXFVertex.getBulge();
            if (d2 != 0.0) {
                dXFVertex.setBulge(0.0);
            }
            if (d != 0.0) {
                dXFVertex.setBulge(d * -1.0);
            }
            d = d2;
            arrayList.add(dXFVertex);
            dXFPolyline.removeVertex(0);
        }
        for (n = 1; n <= n2; ++n) {
            dXFPolyline.addVertex((DXFVertex)arrayList.get(n2 - n));
        }
    }

    public static double getArcRadius(DXFVertex dXFVertex, DXFVertex dXFVertex2) {
        double d = 4.0 * Math.atan(Math.abs(dXFVertex.getBulge()));
        double d2 = MathUtils.distance(dXFVertex.getPoint(), dXFVertex2.getPoint());
        double d3 = d2 / (2.0 * Math.sin(d / 2.0));
        return d3;
    }

    public static boolean equals(Point point, Point point2, double d) {
        return DXFUtils.distance(point, point2) < d;
    }
}

