/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.dxf.objects;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.kabeja.dxf.objects.DXFObject;

public class DXFDictionary
extends DXFObject {
    protected ArrayList records = new ArrayList();

    public String getObjectType() {
        return "DICTIONARY";
    }

    public boolean hasDXFObjectByID(String string) {
        return this.findByID(string) != null;
    }

    public String getNameForDXFObjectID(String string) {
        return this.findByID(string).getName();
    }

    public DXFObject getDXFObjectByID(String string) {
        DXFDictionaryRecord dXFDictionaryRecord;
        DXFDictionary dXFDictionary = this.getDXFDictionaryForID(string);
        if (dXFDictionary != null && (dXFDictionaryRecord = dXFDictionary.findByID(string)) != null) {
            return dXFDictionaryRecord.getDXFObject();
        }
        return null;
    }

    public DXFObject getDXFObjectByName(String string) {
        DXFDictionaryRecord dXFDictionaryRecord = this.findByName(string);
        if (dXFDictionaryRecord != null) {
            return dXFDictionaryRecord.getDXFObject();
        }
        return null;
    }

    public void putDXFObject(DXFObject dXFObject) {
        this.findByID(dXFObject.getID()).setDXFObject(dXFObject);
    }

    public void putDXFObjectRelation(String string, String string2) {
        DXFDictionaryRecord dXFDictionaryRecord = null;
        dXFDictionaryRecord = this.findByName(string);
        if (dXFDictionaryRecord != null) {
            dXFDictionaryRecord.setID(string2);
        } else {
            dXFDictionaryRecord = new DXFDictionaryRecord(string, string2);
            this.records.add(dXFDictionaryRecord);
        }
    }

    protected DXFDictionaryRecord findByName(String string) {
        for (int i = 0; i < this.records.size(); ++i) {
            DXFDictionaryRecord dXFDictionaryRecord = (DXFDictionaryRecord)this.records.get(i);
            if (!dXFDictionaryRecord.getName().equals(string)) continue;
            return dXFDictionaryRecord;
        }
        return null;
    }

    protected DXFDictionaryRecord findByID(String string) {
        for (int i = 0; i < this.records.size(); ++i) {
            DXFDictionaryRecord dXFDictionaryRecord = (DXFDictionaryRecord)this.records.get(i);
            if (!dXFDictionaryRecord.getID().equals(string)) continue;
            return dXFDictionaryRecord;
        }
        return null;
    }

    public DXFDictionary getDXFDictionaryForID(String string) {
        Object object;
        HashSet<DXFObject> hashSet = new HashSet<DXFObject>();
        DXFObject dXFObject = null;
        for (int i = 0; i < this.records.size(); ++i) {
            object = (DXFDictionaryRecord)this.records.get(i);
            if (((DXFDictionaryRecord)object).getID().equals(string)) {
                return this;
            }
            dXFObject = ((DXFDictionaryRecord)object).getDXFObject();
            if (dXFObject == null || !dXFObject.getObjectType().equals("DICTIONARY")) continue;
            hashSet.add(dXFObject);
        }
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            object = (DXFDictionary)iterator.next();
            DXFDictionary dXFDictionary = ((DXFDictionary)object).getDXFDictionaryForID(string);
            if (dXFDictionary == null) continue;
            return dXFDictionary;
        }
        return null;
    }

    public Iterator getDXFObjectIterator() {
        Iterator iterator = new Iterator(){
            int count = 0;

            public boolean hasNext() {
                return this.count < DXFDictionary.this.records.size();
            }

            public Object next() {
                return ((DXFDictionaryRecord)DXFDictionary.this.records.get(this.count++)).getDXFObject();
            }

            public void remove() {
                DXFDictionary.this.records.remove(this.count - 1);
            }
        };
        return iterator;
    }

    private class DXFDictionaryRecord {
        private String id;
        private String name;
        private DXFObject obj;

        public DXFDictionaryRecord(String string, String string2) {
            this.id = string2;
            this.name = string;
        }

        public String getName() {
            return this.name;
        }

        public String getID() {
            return this.id;
        }

        public void setID(String string) {
            this.id = string;
        }

        public void setDXFObject(DXFObject dXFObject) {
            this.obj = dXFObject;
        }

        public DXFObject getDXFObject() {
            return this.obj;
        }
    }
}

