/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.parser;

import java.util.Hashtable;
import java.util.Iterator;
import org.kabeja.parser.AbstractSectionHandler;
import org.kabeja.parser.DXFValue;
import org.kabeja.parser.Handler;
import org.kabeja.parser.HandlerManager;
import org.kabeja.parser.table.DXFTableHandler;

public class DXFTableSectionHandler
extends AbstractSectionHandler
implements HandlerManager {
    public static final String sectionKey = "TABLES";
    public static final String TABLE_START = "TABLE";
    public static final String TABLE_END = "ENDTAB";
    public final int TABLE_CODE = 0;
    private String table = "";
    private DXFTableHandler handler;
    private Hashtable handlers = new Hashtable();
    private boolean parse = false;

    public String getSectionKey() {
        return sectionKey;
    }

    public void parseGroup(int n, DXFValue dXFValue) {
        if (n == 0) {
            if (TABLE_END.equals(dXFValue)) {
                this.table = "";
                if (this.parse) {
                    this.handler.endParsing();
                    this.parse = false;
                }
            } else if (!TABLE_START.equals(dXFValue)) {
                if (this.parse) {
                    this.handler.endParsing();
                }
                this.table = dXFValue.getValue();
                if (this.handlers.containsKey(this.table)) {
                    this.handler = (DXFTableHandler)this.handlers.get(this.table);
                    this.handler.setDXFDocument(this.doc);
                    this.handler.startParsing();
                    this.parse = true;
                } else {
                    this.parse = false;
                }
            }
        } else if (this.parse) {
            this.handler.parseGroup(n, dXFValue);
        }
    }

    public void endSection() {
    }

    public void startSection() {
        this.parse = false;
    }

    public void addHandler(Handler handler) {
        this.addDXFTableHandler((DXFTableHandler)handler);
    }

    public void addDXFTableHandler(DXFTableHandler dXFTableHandler) {
        this.handlers.put(dXFTableHandler.getTableKey(), dXFTableHandler);
    }

    public void releaseDXFDocument() {
        this.doc = null;
        Iterator iterator = this.handlers.values().iterator();
        while (iterator.hasNext()) {
            Handler handler = (Handler)iterator.next();
            handler.releaseDXFDocument();
        }
    }
}

