/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.parser.entities;

import org.kabeja.dxf.DXFDocument;
import org.kabeja.dxf.DXFEntity;
import org.kabeja.parser.DXFValue;
import org.kabeja.parser.entities.DXFEntityHandler;

public abstract class AbstractEntityHandler
implements DXFEntityHandler {
    public static final int ELEMENT_REFERENCE = 5;
    public static final int GROUPCODE_START_X = 10;
    public static final int GROUPCODE_START_Y = 20;
    public static final int GROUPCODE_START_Z = 30;
    public static final int END_X = 11;
    public static final int END_Y = 21;
    public static final int END_Z = 31;
    public static final int LAYER_NAME = 8;
    public static final int TRANSPARENCY = 440;
    public static final int COLOR_CODE = 62;
    public static final int COLORNAME = 430;
    public static final int COLOR_24BIT = 420;
    public static final int COLOR_TRANSPARENCY = 440;
    public static final int FLAGS = 70;
    public static final int EXTRUSION_X = 210;
    public static final int EXTRUSION_Y = 220;
    public static final int EXTRUSION_Z = 230;
    public static final int VISIBILITY = 60;
    public static final int LINE_TYPE = 6;
    public static final int LINE_TYPE_SCALE = 48;
    public static final int LINE_WEIGHT = 370;
    public static final int GROUPCODE_THICKNESS = 39;
    public static final int GROUPCODE_STYLENAME = 3;
    public static final int GROUPCODE_TEXT = 1;
    public static final int GROUPCODE_ROTATION_ANGLE = 50;
    public static final int GROUPCODE_MODELSPACE = 67;
    protected DXFDocument doc;

    public void setDXFDocument(DXFDocument dXFDocument) {
        this.doc = dXFDocument;
    }

    protected void parseCommonProperty(int n, DXFValue dXFValue, DXFEntity dXFEntity) {
        switch (n) {
            case 5: {
                dXFEntity.setID(dXFValue.getValue());
                break;
            }
            case 8: {
                dXFEntity.setLayerName(dXFValue.getValue());
                break;
            }
            case 70: {
                dXFEntity.setFlags(dXFValue.getIntegerValue());
                break;
            }
            case 60: {
                dXFEntity.setVisibile(!dXFValue.getBooleanValue());
                break;
            }
            case 6: {
                dXFEntity.setLineType(dXFValue.getValue());
                break;
            }
            case 48: {
                dXFEntity.setLinetypeScaleFactor(dXFValue.getDoubleValue());
                break;
            }
            case 62: {
                dXFEntity.setColor(dXFValue.getIntegerValue());
                break;
            }
            case 210: {
                dXFEntity.setExtrusionX(dXFValue.getDoubleValue());
                break;
            }
            case 220: {
                dXFEntity.setExtrusionY(dXFValue.getDoubleValue());
                break;
            }
            case 230: {
                dXFEntity.setExtrusionZ(dXFValue.getDoubleValue());
                break;
            }
            case 420: {
                break;
            }
            case 440: {
                break;
            }
            case 370: {
                dXFEntity.setLineWeight(dXFValue.getIntegerValue());
                break;
            }
            case 39: {
                dXFEntity.setThickness(dXFValue.getDoubleValue());
                break;
            }
            case 67: {
                dXFEntity.setModelSpace(dXFValue.getBooleanValue());
            }
        }
    }

    public abstract String getDXFEntityName();

    public void releaseDXFDocument() {
        this.doc = null;
    }
}

