/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.parser.entities;

import java.util.Hashtable;
import java.util.Iterator;
import org.kabeja.dxf.DXFDocument;
import org.kabeja.dxf.DXFEntity;
import org.kabeja.dxf.DXFHatch;
import org.kabeja.dxf.DXFHatchPattern;
import org.kabeja.dxf.DXFPolyline;
import org.kabeja.dxf.DXFVertex;
import org.kabeja.dxf.helpers.HatchBoundaryLoop;
import org.kabeja.dxf.helpers.HatchLineFamily;
import org.kabeja.parser.DXFValue;
import org.kabeja.parser.entities.AbstractEntityHandler;
import org.kabeja.parser.entities.DXFArcHandler;
import org.kabeja.parser.entities.DXFEllipseHandler;
import org.kabeja.parser.entities.DXFEntityHandler;
import org.kabeja.parser.entities.DXFLineHandler;
import org.kabeja.parser.entities.DXFSplineHandler;

public class DXFHatchHandler
extends AbstractEntityHandler {
    public static final String END_SEQUENCE = "SEQEND";
    public static final int END_SEQUENCE_CODE = -2;
    public static final int GROUPCODE_ASSOSIATIVITY_FLAG = 71;
    public static final int GROUPCODE_BOUNDARY_ANNOTATION = 73;
    public static final int GROUPCODE_BOUNDARY_EDGE_COUNT = 93;
    public static final int GROUPCODE_BOUNDARY_EDGE_TYPE = 72;
    public static final int GROUPCODE_BOUNDARY_LOOP_COUNT = 91;
    public static final int GROUPCODE_BOUNDAYY_LOOP_TYPE = 92;
    public static final int GROUPCODE_DEFINITION_LINE_COUNT = 78;
    public static final int GROUPCODE_DEGENERTE_BOUNDARY_PATH_COUNT = 99;
    public static final int GROUPCODE_HATCH_DOUBLE_FLAG = 77;
    public static final int GROUPCODE_HATCH_STYLE = 75;
    public static final int GROUPCODE_NAME = 2;
    public static final int GROUPCODE_OFFSET_VECTOR = 11;
    public static final int GROUPCODE_PATTERN_ANGLE = 52;
    public static final int GROUPCODE_PATTERN_BASE_X = 43;
    public static final int GROUPCODE_PATTERN_BASE_Y = 44;
    public static final int GROUPCODE_PATTERN_FILL_COLOR = 63;
    public static final int GROUPCODE_PATTERN_LINE_ANGLE = 53;
    public static final int GROUPCODE_PATTERN_LINE_COUNT = 79;
    public static final int GROUPCODE_PATTERN_LINE_TYPE_DATA = 49;
    public static final int GROUPCODE_PATTERN_OFFSET_X = 45;
    public static final int GROUPCODE_PATTERN_OFFSET_Y = 46;
    public static final int GROUPCODE_PATTERN_SCALE = 41;
    public static final int GROUPCODE_PATTERN_TYPE = 76;
    public static final int GROUPCODE_PIXEL_SIZE = 47;
    public static final int GROUPCODE_SEED_POINTS_COUNT = 98;
    public static final int GROUPCODE_SOLID_FILL_FLAG = 70;
    protected DXFEntityHandler boundaryHandler;
    protected Hashtable boundaryHandlers = new Hashtable();
    protected int count;
    private boolean follow = false;
    private DXFHatch hatch;
    protected HatchLineFamily linePattern = new HatchLineFamily();
    protected HatchBoundaryLoop loop;
    protected double[] parameters = new double[0];
    private boolean parseBoundary = false;
    protected DXFHatchPattern pattern;
    protected DXFPolyline polyline;
    private boolean polylineBoundary = false;
    protected DXFVertex vertex;
    protected int lastGroupCode;

    public DXFHatchHandler() {
        this.init();
    }

    protected void endBoundaryElement() {
        if (this.boundaryHandler != null) {
            this.boundaryHandler.endDXFEntity();
            this.loop.addBoundaryEdge(this.boundaryHandler.getDXFEntity());
            this.boundaryHandler = null;
        }
    }

    public void endDXFEntity() {
        if (this.pattern != null) {
            this.hatch.setDXFHatchPatternID(this.pattern.getID());
        }
    }

    public DXFEntity getDXFEntity() {
        return this.hatch;
    }

    public String getDXFEntityName() {
        return "HATCH";
    }

    protected void init() {
        AbstractEntityHandler abstractEntityHandler = new DXFSplineHandler();
        this.boundaryHandlers.put(abstractEntityHandler.getDXFEntityName(), abstractEntityHandler);
        abstractEntityHandler = new DXFLineHandler();
        this.boundaryHandlers.put(abstractEntityHandler.getDXFEntityName(), abstractEntityHandler);
        abstractEntityHandler = new DXFArcHandler();
        this.boundaryHandlers.put(abstractEntityHandler.getDXFEntityName(), abstractEntityHandler);
        abstractEntityHandler = new DXFEllipseHandler();
        this.boundaryHandlers.put(abstractEntityHandler.getDXFEntityName(), abstractEntityHandler);
    }

    public boolean isFollowSequence() {
        return false;
    }

    protected void parseBoundary(int n, DXFValue dXFValue) {
        if (this.polylineBoundary) {
            this.parsePolylineBoundary(n, dXFValue);
        } else {
            this.boundaryHandler.parseGroup(n, dXFValue);
        }
    }

    public void parseGroup(int n, DXFValue dXFValue) {
        switch (n) {
            case 91: {
                break;
            }
            case 93: {
                break;
            }
            case 72: {
                if (this.lastGroupCode == 92) {
                    this.polylineBoundary = true;
                    this.polyline = new DXFPolyline();
                    this.polyline.setDXFDocument(this.doc);
                    this.loop.addBoundaryEdge(this.polyline);
                    break;
                }
                if (this.polylineBoundary) break;
                this.endBoundaryElement();
                switch (dXFValue.getIntegerValue()) {
                    case 1: {
                        this.boundaryHandler = (DXFEntityHandler)this.boundaryHandlers.get("LINE");
                        this.boundaryHandler.startDXFEntity();
                        break;
                    }
                    case 2: {
                        this.boundaryHandler = (DXFEntityHandler)this.boundaryHandlers.get("ARC");
                        this.boundaryHandler.startDXFEntity();
                        break;
                    }
                    case 3: {
                        this.boundaryHandler = (DXFEntityHandler)this.boundaryHandlers.get("ELLIPSE");
                        this.boundaryHandler.startDXFEntity();
                        break;
                    }
                    case 4: {
                        this.boundaryHandler = (DXFEntityHandler)this.boundaryHandlers.get("SPLINE");
                        this.boundaryHandler.startDXFEntity();
                    }
                }
                break;
            }
            case 92: {
                if (!this.polylineBoundary) {
                    this.endBoundaryElement();
                }
                this.loop = new HatchBoundaryLoop();
                this.hatch.addBoundaryLoop(this.loop);
                this.polylineBoundary = false;
                this.parseBoundary = true;
                if ((dXFValue.getIntegerValue() & 2) == 2) {
                    // empty if block
                }
                if ((dXFValue.getIntegerValue() & 1) == 1) {
                    // empty if block
                }
                if ((dXFValue.getIntegerValue() & 4) == 4) {
                    // empty if block
                }
                if ((dXFValue.getIntegerValue() & 0x10) != 16) break;
                this.loop.setOutermost(false);
                break;
            }
            case 2: {
                this.hatch.setName(dXFValue.getValue());
                break;
            }
            case 10: {
                if (this.parseBoundary) {
                    this.parseBoundary(n, dXFValue);
                    break;
                }
                this.hatch.getElevationPoint().setX(dXFValue.getDoubleValue());
                break;
            }
            case 20: {
                if (this.parseBoundary) {
                    this.parseBoundary(n, dXFValue);
                    break;
                }
                this.hatch.getElevationPoint().setY(dXFValue.getDoubleValue());
                break;
            }
            case 30: {
                if (this.parseBoundary) {
                    this.parseBoundary(n, dXFValue);
                    break;
                }
                this.hatch.getElevationPoint().setZ(dXFValue.getDoubleValue());
                break;
            }
            case 75: {
                this.parseBoundary = false;
                this.endBoundaryElement();
                break;
            }
            case 53: {
                this.parseBoundary = false;
                this.linePattern = new HatchLineFamily();
                this.pattern.addLineFamily(this.linePattern);
                this.linePattern.setRotationAngle(dXFValue.getDoubleValue());
                this.count = 0;
                break;
            }
            case 43: {
                this.linePattern.setBaseX(dXFValue.getDoubleValue());
                break;
            }
            case 44: {
                this.linePattern.setBaseY(dXFValue.getDoubleValue());
                break;
            }
            case 45: {
                this.linePattern.setOffsetX(dXFValue.getDoubleValue());
                break;
            }
            case 46: {
                this.linePattern.setOffsetY(dXFValue.getDoubleValue());
                break;
            }
            case 79: {
                this.parameters = new double[dXFValue.getIntegerValue()];
                this.linePattern.setPattern(this.parameters);
                break;
            }
            case 49: {
                this.parameters[this.count] = dXFValue.getDoubleValue();
                ++this.count;
                break;
            }
            case 41: {
                this.hatch.setPatternScale(dXFValue.getDoubleValue());
                break;
            }
            default: {
                if (this.parseBoundary) {
                    this.parseBoundary(n, dXFValue);
                    break;
                }
                super.parseCommonProperty(n, dXFValue, this.hatch);
            }
        }
        this.lastGroupCode = n;
    }

    protected void parsePolylineBoundary(int n, DXFValue dXFValue) {
        switch (n) {
            case 10: {
                this.vertex = new DXFVertex();
                this.polyline.addVertex(this.vertex);
                this.vertex.setX(dXFValue.getDoubleValue());
                break;
            }
            case 20: {
                this.vertex.setY(dXFValue.getDoubleValue());
                break;
            }
            case 30: {
                this.vertex.setZ(dXFValue.getDoubleValue());
                break;
            }
            case 42: {
                this.vertex.setBulge(dXFValue.getDoubleValue());
                break;
            }
            case 73: {
                this.polyline.setFlags(1);
            }
        }
    }

    public void setDXFDocument(DXFDocument dXFDocument) {
        super.setDXFDocument(dXFDocument);
        Iterator iterator = this.boundaryHandlers.values().iterator();
        while (iterator.hasNext()) {
            DXFEntityHandler dXFEntityHandler = (DXFEntityHandler)iterator.next();
            dXFEntityHandler.setDXFDocument(dXFDocument);
        }
    }

    public void startDXFEntity() {
        this.hatch = new DXFHatch();
        this.pattern = new DXFHatchPattern();
        this.pattern.setHatch(this.hatch);
        this.doc.addDXFHatchPattern(this.pattern);
        this.parseBoundary = false;
        this.polylineBoundary = false;
        this.boundaryHandler = null;
    }
}

