/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.parser.entities;

import org.kabeja.dxf.DXFEntity;
import org.kabeja.dxf.DXFText;
import org.kabeja.parser.DXFValue;
import org.kabeja.parser.entities.AbstractEntityHandler;

public class DXFTextHandler
extends AbstractEntityHandler {
    public static final int TEXT_VALUE = 1;
    public static final int TEXT_HEIGHT = 40;
    public static final int TEXT_SCALEX = 41;
    public static final int TEXT_GENERATION_FLAG = 71;
    public static final int TEXT_ALIGN = 72;
    public static final int TEXT_VALIGN = 73;
    public static final int TEXT_ALIGN_X = 11;
    public static final int TEXT_ALIGN_Y = 21;
    public static final int TEXT_ALIGN_Z = 31;
    public static final int TEXT_STYLE = 7;
    public static final int TEXT_OBLIQUEANGLE = 51;
    public static final int TEXT_ROTATION = 50;
    protected DXFText text;
    protected String content;

    public void endDXFEntity() {
        this.text.setText(this.content);
        this.content = "";
    }

    public DXFEntity getDXFEntity() {
        return this.text;
    }

    public String getDXFEntityName() {
        return "TEXT";
    }

    public boolean isFollowSequence() {
        return false;
    }

    public void parseGroup(int n, DXFValue dXFValue) {
        switch (n) {
            case 1: {
                this.content = dXFValue.getValue();
                break;
            }
            case 72: {
                this.text.setAlign(dXFValue.getIntegerValue());
                break;
            }
            case 73: {
                this.text.setValign(dXFValue.getIntegerValue());
                break;
            }
            case 10: {
                this.text.setX(dXFValue.getDoubleValue());
                break;
            }
            case 20: {
                this.text.setY(dXFValue.getDoubleValue());
                break;
            }
            case 30: {
                this.text.setZ(dXFValue.getDoubleValue());
                break;
            }
            case 11: {
                this.text.setAlignX(dXFValue.getDoubleValue());
                this.text.setAlignmentPoint(true);
                break;
            }
            case 21: {
                this.text.setAlignY(dXFValue.getDoubleValue());
                this.text.setAlignmentPoint(true);
                break;
            }
            case 31: {
                this.text.setAlignZ(dXFValue.getDoubleValue());
                this.text.setAlignmentPoint(true);
                break;
            }
            case 40: {
                this.text.setHeight(dXFValue.getDoubleValue());
                break;
            }
            case 71: {
                switch (dXFValue.getIntegerValue()) {
                    case 2: {
                        this.text.setBackward(true);
                        break;
                    }
                    case 4: {
                        this.text.setUpsideDown(true);
                    }
                }
                break;
            }
            case 7: {
                this.text.setTextStyle(dXFValue.getValue());
                break;
            }
            case 50: {
                this.text.setRotation(dXFValue.getDoubleValue());
                break;
            }
            case 41: {
                this.text.setScaleX(dXFValue.getDoubleValue());
                break;
            }
            case 51: {
                this.text.setObliqueAngle(dXFValue.getDoubleValue());
                break;
            }
            default: {
                super.parseCommonProperty(n, dXFValue, this.text);
            }
        }
    }

    public void startDXFEntity() {
        this.text = new DXFText();
        this.text.setDXFDocument(this.doc);
    }
}

