/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.parser.objects;

import org.kabeja.dxf.objects.DXFObject;
import org.kabeja.dxf.objects.DXFPlotSettings;
import org.kabeja.parser.DXFValue;
import org.kabeja.parser.objects.AbstractDXFObjectHandler;

public class DXFPlotsettingsHandler
extends AbstractDXFObjectHandler {
    public static final int GROUPCODE_NAME = 1;
    public static final int GROUPCODE_PLOT_CONFIGURATION_FILE = 2;
    public static final int GROUPCODE_PAPER_SIZE = 4;
    public static final int GROUPCODE_PLOT_VIEW_NAME = 6;
    public static final int GROUPCODE_MARGIN_LEFT = 40;
    public static final int GROUPCODE_MARGIN_BOTTOM = 41;
    public static final int GROUPCODE_MARGIN_RIGHT = 42;
    public static final int GROUPCODE_MARGIN_TOP = 43;
    public static final int GROUPCODE_PLOT_PAPER_WIDTH = 44;
    public static final int GROUPCODE_PLOT_PAPER_HEIGHT = 45;
    public static final int GROUPCODE_ORIGIN_X = 46;
    public static final int GROUPCODE_ORIGIN_Y = 47;
    public static final int GROUPCODE_PLOT_WINDOW_MIN_X = 48;
    public static final int GROUPCODE_PLOT_WINDOWS_MIN_Y = 49;
    public static final int GROUPCODE_PLOT_WINDOW_MAX_X = 140;
    public static final int GROUPCODE_PLOT_WINDOWS_MAX_Y = 141;
    public static final int GROUPCODE_CUSTOM_SCALE_NUMERATOR = 142;
    public static final int GROUPCODE_CUSTOM_SCALE_DEOMINATOR = 143;
    public static final int GROUPCODE_PAPER_UNITS = 72;
    public static final int GROUPCODE_PLOT_ROTATION = 73;
    public static final int GROUPCODE_PLOT_TYPE = 74;
    public static final int GROUPCODE_CURRENT_STYLESHEET = 7;
    public static final int GROUPCODE_STANDARD_SCALE_TYPE = 75;
    protected DXFPlotSettings plotSettings;

    public void endObject() {
    }

    public DXFObject getDXFObject() {
        return this.plotSettings;
    }

    public String getObjectType() {
        return "PLOTSETTINGS";
    }

    public void parseGroup(int n, DXFValue dXFValue) {
        switch (n) {
            case 7: {
                this.plotSettings.setCurrentStylesheet(dXFValue.getValue());
                break;
            }
            case 143: {
                this.plotSettings.setCustomScaleDenominator(dXFValue.getDoubleValue());
                break;
            }
            case 142: {
                this.plotSettings.setCustomScaleNumerator(dXFValue.getDoubleValue());
                break;
            }
            case 41: {
                double[] dArray = this.plotSettings.getMargin();
                dArray[2] = dXFValue.getDoubleValue();
                this.plotSettings.setMargin(dArray);
                break;
            }
            case 40: {
                double[] dArray = this.plotSettings.getMargin();
                dArray[3] = dXFValue.getDoubleValue();
                this.plotSettings.setMargin(dArray);
                break;
            }
            case 42: {
                double[] dArray = this.plotSettings.getMargin();
                dArray[1] = dXFValue.getDoubleValue();
                this.plotSettings.setMargin(dArray);
                break;
            }
            case 43: {
                double[] dArray = this.plotSettings.getMargin();
                dArray[0] = dXFValue.getDoubleValue();
                this.plotSettings.setMargin(dArray);
                break;
            }
            case 46: {
                this.plotSettings.getPlotOrigin().setX(dXFValue.getDoubleValue());
                break;
            }
            case 47: {
                this.plotSettings.getPlotOrigin().setY(dXFValue.getDoubleValue());
                break;
            }
            case 1: {
                this.plotSettings.setName(dXFValue.getValue());
                break;
            }
            case 4: {
                break;
            }
            case 72: {
                this.plotSettings.setPaperUnit(dXFValue.getIntegerValue());
                break;
            }
            case 2: {
                break;
            }
            case 45: {
                this.plotSettings.setPaperHeight(dXFValue.getDoubleValue());
                break;
            }
            case 44: {
                this.plotSettings.setPaperWidth(dXFValue.getDoubleValue());
                break;
            }
            case 73: {
                this.plotSettings.setPlotRotation(dXFValue.getIntegerValue());
                break;
            }
            case 74: {
                this.plotSettings.setPlotType(dXFValue.getIntegerValue());
                break;
            }
            case 6: {
                this.plotSettings.setPlotViewName(dXFValue.getValue());
                break;
            }
            case 140: {
                this.plotSettings.getWindowToPlot().setMaximumX(dXFValue.getDoubleValue());
                break;
            }
            case 48: {
                this.plotSettings.getWindowToPlot().setMinimumX(dXFValue.getDoubleValue());
                break;
            }
            case 141: {
                this.plotSettings.getWindowToPlot().setMaximumY(dXFValue.getDoubleValue());
                break;
            }
            case 49: {
                this.plotSettings.getWindowToPlot().setMinimumY(dXFValue.getDoubleValue());
                break;
            }
            default: {
                super.parseCommonGroupCode(n, dXFValue, this.plotSettings);
            }
        }
    }

    public void startObject() {
        this.plotSettings = new DXFPlotSettings();
    }
}

