/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.processing;

import java.util.Iterator;
import java.util.Map;
import org.kabeja.dxf.Bounds;
import org.kabeja.dxf.DXFDocument;
import org.kabeja.dxf.DXFEntity;
import org.kabeja.dxf.DXFLayer;
import org.kabeja.dxf.DXFView;
import org.kabeja.processing.AbstractPostProcessor;
import org.kabeja.processing.ProcessorException;

public class ViewFilter
extends AbstractPostProcessor {
    public static final String CONTEXT_OPTION_VIEW_NAME = "view.name";

    public void process(DXFDocument dXFDocument, Map map) throws ProcessorException {
        DXFView dXFView = null;
        Iterator iterator = dXFDocument.getDXFViewIterator();
        if (map.containsKey(CONTEXT_OPTION_VIEW_NAME)) {
            String string = (String)map.get(CONTEXT_OPTION_VIEW_NAME);
            boolean bl = false;
            while (iterator.hasNext() && !bl) {
                DXFView dXFView2 = (DXFView)iterator.next();
                if (!dXFView2.getName().trim().equals(string.trim())) continue;
                dXFView = dXFView2;
                bl = true;
            }
        } else if (iterator.hasNext()) {
            dXFView = (DXFView)iterator.next();
        }
        if (dXFView != null) {
            double d = dXFView.getWidth() / 2.0;
            double d2 = dXFView.getHeight() / 2.0;
            Bounds bounds = new Bounds();
            bounds.addToBounds(dXFView.getCenterPoint().getX() + d, dXFView.getCenterPoint().getY() + d2, dXFView.getCenterPoint().getZ());
            bounds.addToBounds(dXFView.getCenterPoint().getX() - d, dXFView.getCenterPoint().getY() - d2, dXFView.getCenterPoint().getZ());
            this.filterEntities(bounds, dXFDocument);
        }
    }

    protected void filterEntities(Bounds bounds, DXFDocument dXFDocument) {
        Iterator iterator = dXFDocument.getDXFLayerIterator();
        while (iterator.hasNext()) {
            DXFLayer dXFLayer = (DXFLayer)iterator.next();
            Iterator iterator2 = dXFLayer.getDXFEntityTypeIterator();
            while (iterator2.hasNext()) {
                String string = (String)iterator2.next();
                Iterator iterator3 = dXFLayer.getDXFEntities(string).iterator();
                while (iterator3.hasNext()) {
                    DXFEntity dXFEntity = (DXFEntity)iterator3.next();
                    Bounds bounds2 = dXFEntity.getBounds();
                    if (bounds.contains(bounds2)) continue;
                    iterator3.remove();
                }
            }
        }
    }

    public void setProperties(Map map) {
    }
}

