/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.processing.helper;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.kabeja.dxf.DXFArc;
import org.kabeja.dxf.DXFConstants;
import org.kabeja.dxf.DXFEntity;
import org.kabeja.dxf.DXFLayer;
import org.kabeja.dxf.DXFLine;
import org.kabeja.dxf.DXFPolyline;
import org.kabeja.dxf.DXFVertex;
import org.kabeja.dxf.helpers.DXFUtils;
import org.kabeja.dxf.helpers.Point;

public class PolylineQueue {
    private List elements = new ArrayList();
    private Point startPoint;
    private Point endPoint;
    private double radius = DXFConstants.POINT_CONNECTION_RADIUS;

    public PolylineQueue(DXFEntity dXFEntity, Point point, Point point2, double d) {
        this.elements.add(dXFEntity);
        this.startPoint = point;
        this.endPoint = point2;
        this.radius = d;
    }

    public int size() {
        return this.elements.size();
    }

    public boolean connectDXFEntity(DXFEntity dXFEntity, Point point, Point point2) {
        if (DXFUtils.equals(this.startPoint, point2, this.radius)) {
            this.startPoint = point;
            this.elements.add(0, dXFEntity);
            return true;
        }
        if (DXFUtils.equals(this.endPoint, point, this.radius)) {
            this.endPoint = point2;
            this.elements.add(dXFEntity);
            return true;
        }
        if (DXFUtils.equals(this.startPoint, point, this.radius)) {
            this.startPoint = point2;
            this.reverse(dXFEntity);
            this.elements.add(0, dXFEntity);
            return true;
        }
        if (DXFUtils.equals(this.endPoint, point2, this.radius)) {
            this.endPoint = point;
            this.reverse(dXFEntity);
            this.elements.add(dXFEntity);
            return true;
        }
        return false;
    }

    public Point getStartPoint() {
        return this.startPoint;
    }

    public Point getEndPoint() {
        return this.endPoint;
    }

    public Iterator getElementIterator() {
        return this.elements.iterator();
    }

    public boolean connect(PolylineQueue polylineQueue) {
        if (DXFUtils.equals(polylineQueue.getStartPoint(), this.endPoint, this.radius)) {
            this.add(polylineQueue);
            return true;
        }
        if (DXFUtils.equals(polylineQueue.getEndPoint(), this.startPoint, this.radius)) {
            this.insertBefore(polylineQueue);
            return true;
        }
        if (DXFUtils.equals(polylineQueue.getStartPoint(), this.startPoint, this.radius)) {
            polylineQueue.reverse();
            this.insertBefore(polylineQueue);
            return true;
        }
        if (DXFUtils.equals(polylineQueue.getEndPoint(), this.endPoint, this.radius)) {
            polylineQueue.reverse();
            this.add(polylineQueue);
            return true;
        }
        return false;
    }

    public void createDXFPolyline(DXFLayer dXFLayer) {
        DXFPolyline dXFPolyline = new DXFPolyline();
        DXFVertex dXFVertex = new DXFVertex(this.startPoint);
        dXFPolyline.addVertex(dXFVertex);
        Iterator iterator = this.elements.iterator();
        while (iterator.hasNext()) {
            double d;
            DXFEntity dXFEntity;
            DXFEntity dXFEntity2 = (DXFEntity)iterator.next();
            if ("LINE".equals(dXFEntity2.getType())) {
                dXFEntity = (DXFLine)dXFEntity2;
                dXFVertex = new DXFVertex(((DXFLine)dXFEntity).getEndPoint());
                dXFPolyline.addVertex(dXFVertex);
            } else if ("POLYLINE".equals(dXFEntity2.getType()) || "LWPOLYLINE".equals(dXFEntity2.getType())) {
                dXFEntity = (DXFPolyline)dXFEntity2;
                d = ((DXFPolyline)dXFEntity).getVertex(0).getBulge();
                if (d != 0.0) {
                    dXFVertex.setBulge(d);
                }
                for (int i = 1; i < ((DXFPolyline)dXFEntity).getVertexCount(); ++i) {
                    dXFVertex = ((DXFPolyline)dXFEntity).getVertex(i);
                    dXFPolyline.addVertex(dXFVertex);
                }
            } else if ("ARC".equals(dXFEntity2.getType()) && ((DXFArc)(dXFEntity = (DXFArc)dXFEntity2)).getTotalAngle() > 0.0) {
                d = ((DXFArc)dXFEntity).getRadius() * (1.0 - Math.cos(Math.toRadians(((DXFArc)dXFEntity).getTotalAngle() / 2.0)));
                double d2 = ((DXFArc)dXFEntity).getChordLength();
                if (DXFUtils.equals(((DXFArc)dXFEntity).getStartPoint(), dXFVertex.getPoint(), this.radius)) {
                    dXFVertex.setBulge(2.0 * d / d2);
                    dXFVertex = new DXFVertex(((DXFArc)dXFEntity).getEndPoint());
                    dXFPolyline.addVertex(dXFVertex);
                } else {
                    dXFVertex.setBulge(-1.0 * (2.0 * d / d2));
                    dXFVertex = new DXFVertex(((DXFArc)dXFEntity).getStartPoint());
                    dXFPolyline.addVertex(dXFVertex);
                }
            }
            dXFLayer.removeDXFEntity(dXFEntity2);
        }
        dXFPolyline.setLayerName(dXFLayer.getName());
        dXFLayer.addDXFEntity(dXFPolyline);
    }

    protected void reverse(DXFEntity dXFEntity) {
        if ("LINE".equals(dXFEntity.getType())) {
            DXFUtils.reverseDXFLine((DXFLine)dXFEntity);
        } else if ("POLYLINE".equals(dXFEntity.getType()) || "LWPOLYLINE".equals(dXFEntity.getType())) {
            DXFUtils.reverseDXFPolyline((DXFPolyline)dXFEntity);
        } else if ("ARC".equals(dXFEntity.getType())) {
            // empty if block
        }
    }

    protected void reverse() {
        Point point = this.endPoint;
        this.endPoint = this.startPoint;
        this.startPoint = point;
        int n = this.elements.size() - 1;
        for (int i = 0; i < n + 1; ++i) {
            DXFEntity dXFEntity = (DXFEntity)this.elements.get(i);
            this.reverse(dXFEntity);
            if (i >= n) continue;
            DXFEntity dXFEntity2 = this.elements.set(n, dXFEntity);
            this.reverse(dXFEntity2);
            this.elements.set(i, dXFEntity2);
            --n;
        }
    }

    public void insertBefore(PolylineQueue polylineQueue) {
        this.startPoint = polylineQueue.getStartPoint();
        Iterator iterator = polylineQueue.getElementIterator();
        int n = 0;
        while (iterator.hasNext()) {
            DXFEntity dXFEntity = (DXFEntity)iterator.next();
            this.elements.add(n, dXFEntity);
            ++n;
        }
    }

    public void add(PolylineQueue polylineQueue) {
        this.endPoint = polylineQueue.getEndPoint();
        Iterator iterator = polylineQueue.getElementIterator();
        while (iterator.hasNext()) {
            DXFEntity dXFEntity = (DXFEntity)iterator.next();
            this.elements.add(dXFEntity);
        }
    }
}

