/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.tools;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;

public class FontManager {
    private static FontManager instance = new FontManager();
    private String fontDescription = "conf/font.properties";
    private Hashtable fontProperties = new Hashtable();

    private FontManager() {
        this.loadFontDescription();
    }

    public void setFontDescription(String string) {
        this.fontDescription = string;
        this.loadFontDescription();
    }

    private void loadFontDescription() {
        this.fontProperties.clear();
        try {
            InputStream inputStream = this.getClass().getResourceAsStream(this.fontDescription);
            if (inputStream == null) {
                try {
                    inputStream = new FileInputStream(this.fontDescription);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
            if (inputStream != null) {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                String string = null;
                while ((string = bufferedReader.readLine()) != null) {
                    int n = string.indexOf("=");
                    if (n < 0) continue;
                    String string2 = string.substring(0, n).trim().toLowerCase();
                    String string3 = string.substring(n + 1).trim();
                    this.fontProperties.put(string2, string3);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static FontManager getInstance() {
        return instance;
    }

    public boolean hasFontDescription(String string) {
        return this.fontProperties.containsKey(string = this.getFontKey(string));
    }

    public String getFontDescription(String string) {
        return (String)this.fontProperties.get(this.getFontKey(string));
    }

    private String getFontKey(String string) {
        if ((string = string.toLowerCase()).endsWith(".shx")) {
            string = string.substring(0, string.indexOf(".shx"));
        }
        return string;
    }
}

