/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.ui.impl;

import de.miethxml.toolkit.ui.SelectorComponent;
import java.awt.CardLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.kabeja.processing.ProcessingManager;
import org.kabeja.ui.Application;
import org.kabeja.ui.ApplicationMenuBar;
import org.kabeja.ui.ApplicationToolBar;
import org.kabeja.ui.Component;
import org.kabeja.ui.ProcessingUIComponent;
import org.kabeja.ui.ServiceManager;
import org.kabeja.ui.Serviceable;
import org.kabeja.ui.Startable;
import org.kabeja.ui.ViewComponent;
import org.kabeja.ui.impl.AboutAction;
import org.kabeja.ui.impl.Messages;

public class ProcessingUI
implements Serviceable,
Startable,
ProcessingUIComponent,
ApplicationToolBar,
ApplicationMenuBar {
    protected ServiceManager serviceManager;
    protected ProcessingManager manager;
    protected JFrame frame;
    protected List components = new ArrayList();
    private JPanel mainPanel;
    private CardLayout mainContainer;
    private SelectorComponent selector;
    private JPanel panel;
    private JToolBar toolbar;
    private JMenuBar menubar;
    private Map menus = new HashMap();
    private Application application;

    protected void initialize() {
        this.frame = new JFrame(Messages.getString("ProcessingUI.title"));
        this.frame.setDefaultCloseOperation(3);
        this.panel = new JPanel();
        this.panel.setBorder(BorderFactory.createEmptyBorder());
        this.mainContainer = new CardLayout();
        this.mainPanel = new JPanel(this.mainContainer);
        this.toolbar = new JToolBar();
        this.toolbar.add(Box.createHorizontalGlue());
        this.selector = new SelectorComponent();
        this.toolbar.add(this.selector.getView());
        this.frame.getContentPane().add((java.awt.Component)this.toolbar, "North");
        this.menubar = new JMenuBar();
        this.frame.setJMenuBar(this.menubar);
        this.menubar.add(Box.createHorizontalGlue());
        JMenu jMenu = new JMenu(Messages.getString("ProcessingUI.menu.help"));
        jMenu.add(new AboutAction());
        this.menubar.add(jMenu);
        this.menus.put("menu.help", jMenu);
        jMenu = new JMenu(Messages.getString("ProcessingUI.menu.file"));
        jMenu.add(new AbstractAction(Messages.getString("ProcessingUI.menu.file.exit")){

            public void actionPerformed(ActionEvent actionEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ProcessingUI.this.shutdown();
                    }
                });
            }
        });
        this.setMenu("menu.file", jMenu);
        this.frame.getContentPane().add((java.awt.Component)this.mainPanel, "Center");
        this.frame.setSize(700, 620);
        this.frame.validate();
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.frame.setVisible(true);
        } else {
            this.frame.setVisible(false);
        }
    }

    public void addViewComponent(ViewComponent viewComponent) {
        int n = this.components.size();
        this.components.add(viewComponent);
        JComponent jComponent = viewComponent.getView();
        if (this.mainPanel.getMinimumSize().getWidth() < jComponent.getPreferredSize().getWidth()) {
            this.mainPanel.setPreferredSize(jComponent.getPreferredSize());
        }
        this.mainPanel.add((java.awt.Component)jComponent, "" + n);
        SwitchAction switchAction = new SwitchAction(viewComponent.getTitle(), n);
        this.selector.addAction((Action)switchAction);
    }

    public void setServiceManager(ServiceManager serviceManager) {
        this.serviceManager = serviceManager;
        Component[] componentArray = this.serviceManager.getServiceComponents(Application.SERVICE);
        this.application = (Application)componentArray[0];
        this.initialize();
        componentArray = this.serviceManager.getServiceComponents(ViewComponent.SERVICE);
        for (int i = 0; i < componentArray.length; ++i) {
            this.addViewComponent((ViewComponent)componentArray[i]);
        }
    }

    public void setProcessingManager(ProcessingManager processingManager) {
        this.manager = processingManager;
    }

    public void start() {
        this.frame.setVisible(true);
    }

    public void stop() {
        this.frame.setVisible(false);
    }

    public void addAction(Action action) {
        JButton jButton = new JButton(action);
        jButton.setToolTipText(jButton.getText());
        jButton.setText("");
        this.addAction(jButton);
    }

    public void addAction(java.awt.Component component) {
        if (this.toolbar.getComponentCount() > 1) {
            this.toolbar.add(component, this.toolbar.getComponentCount() - 2);
        } else {
            this.toolbar.add(component);
        }
    }

    public boolean hasMenu(String string) {
        return this.menus.containsKey(string);
    }

    public void setAction(String string, Action action) {
        this.setJMenuItem(string, new JMenuItem(action));
    }

    public void setJMenuItem(String string, JMenuItem jMenuItem) {
        if (this.hasMenu(string)) {
            JMenu jMenu = (JMenu)this.menus.get(string);
            if (string.equals("menu.file")) {
                jMenu.add((java.awt.Component)jMenuItem, 0);
            } else {
                jMenu.add(jMenuItem);
            }
        }
    }

    public void setMenu(String string, JMenu jMenu) {
        if (!this.hasMenu(string)) {
            this.menus.put(string, jMenu);
            this.menubar.add((java.awt.Component)jMenu, this.menubar.getComponentCount() - 2);
        }
    }

    protected void shutdown() {
        this.application.stop();
    }

    public class SwitchAction
    extends AbstractAction {
        int index;

        public SwitchAction(String string, int n) {
            super(string);
            this.index = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ProcessingUI.this.mainContainer.show(ProcessingUI.this.mainPanel, "" + this.index);
        }
    }
}

