/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.xml;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import org.kabeja.xml.AbstractSAXSerializer;
import org.kabeja.xml.SAXSerializer;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class SAXPrettyOutputter
extends AbstractSAXSerializer
implements SAXSerializer {
    public static final String DEFAULT_ENCODING = "UTF-8";
    public static final String SUFFIX = "svg";
    public static final String SUFFIX_GZIP = "svgz";
    public static final String MIMETYPE = "text/svg";
    public static final String PROPERTY_ENCODING = "encoding";
    public static final String PROPERTY_GZIP = "gzip";
    private OutputStreamWriter out;
    private String encoding;
    private String dtd;
    private int indent = 0;
    private boolean parent = false;
    private ArrayList textContentList = new ArrayList();
    protected HashMap rootxmlns = new HashMap();
    protected boolean gzip = false;

    public SAXPrettyOutputter(OutputStream outputStream, String string) {
        this.encoding = string;
        this.setOutput(outputStream);
    }

    public SAXPrettyOutputter(OutputStream outputStream) {
        this(outputStream, DEFAULT_ENCODING);
    }

    public SAXPrettyOutputter() {
        this.encoding = DEFAULT_ENCODING;
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        try {
            if (n2 > 0) {
                if (this.parent) {
                    this.out.write(">");
                    this.parent = false;
                }
                char[] cArray2 = SAXPrettyOutputter.encodeXML(new String(cArray, 0, n2)).toCharArray();
                this.out.write(cArray2, n, cArray2.length);
                this.textContentList.set(this.textContentList.size() - 1, new Boolean(true));
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void endDocument() throws SAXException {
        try {
            this.out.flush();
            this.out.close();
            this.textContentList.clear();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        try {
            if (this.parent) {
                this.out.write("/>");
            } else {
                Boolean bl = (Boolean)this.textContentList.remove(this.textContentList.size() - 1);
                if (bl.booleanValue()) {
                    this.out.write("</" + string3 + ">");
                } else {
                    this.out.write(10);
                    this.indentOutput(this.indent);
                    this.out.write("</" + string3 + ">");
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        --this.indent;
        this.parent = false;
    }

    public void endPrefixMapping(String string) throws SAXException {
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    public void processingInstruction(String string, String string2) throws SAXException {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void skippedEntity(String string) throws SAXException {
    }

    public void startDocument() throws SAXException {
        this.indent = 0;
        try {
            this.out.write("<?xml version=\"1.0\" encoding=\"" + this.encoding + "\" ?>");
            if (this.dtd != null) {
                this.out.write("\n<!DOCTYPE " + this.dtd + ">");
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        ++this.indent;
        try {
            if (this.parent) {
                this.out.write(">");
            } else {
                this.parent = true;
            }
            this.out.write(10);
            this.indentOutput(this.indent);
            this.out.write("<" + string3);
            int n = attributes.getLength();
            for (int i = 0; i < n; ++i) {
                this.indentOutput(1);
                String string4 = attributes.getURI(i);
                String string5 = attributes.getQName(i);
                String string6 = attributes.getValue(i);
                if (string6 == null) {
                    string6 = "";
                }
                this.out.write(string5 + "=\"" + SAXPrettyOutputter.encodeXML(attributes.getValue(i)) + "\"");
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.textContentList.add(false);
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
    }

    private void indentOutput(int n) {
        try {
            for (int i = 0; i < n; ++i) {
                this.out.write(32);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static String encodeXML(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '&') {
                stringBuffer.append("&amp;");
                continue;
            }
            if (c == '<') {
                stringBuffer.append("&lt;");
                continue;
            }
            if (c == '>') {
                stringBuffer.append("&gt;");
                continue;
            }
            if (Character.isIdentifierIgnorable(c)) continue;
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public void setDTD(String string) {
        this.dtd = string;
    }

    protected void queryXMLNS(Attributes attributes) {
        for (int i = 0; i < attributes.getLength(); ++i) {
            String string = attributes.getQName(i);
            if (!string.startsWith("xmlns:")) continue;
            String string2 = attributes.getLocalName(i);
            String string3 = attributes.getValue(i);
            this.rootxmlns.put(string3, string2);
        }
    }

    public String getMimeType() {
        return MIMETYPE;
    }

    public String getSuffix() {
        if (this.gzip) {
            return SUFFIX_GZIP;
        }
        return SUFFIX;
    }

    public void setOutput(OutputStream outputStream) {
        BufferedOutputStream bufferedOutputStream = null;
        try {
            bufferedOutputStream = this.gzip ? new BufferedOutputStream(new GZIPOutputStream(outputStream)) : new BufferedOutputStream(outputStream);
            this.out = new OutputStreamWriter((OutputStream)bufferedOutputStream, this.encoding);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setProperties(Map map) {
        this.properties = map;
        if (map.containsKey(PROPERTY_ENCODING)) {
            this.encoding = (String)map.get(PROPERTY_ENCODING);
        }
        if (map.containsKey(PROPERTY_GZIP)) {
            this.gzip = Boolean.getBoolean((String)map.get(PROPERTY_GZIP));
        }
    }
}

