/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.svg.generators;

import java.util.Iterator;
import java.util.Map;
import org.kabeja.dxf.Bounds;
import org.kabeja.dxf.DXFEntity;
import org.kabeja.dxf.DXFHatch;
import org.kabeja.dxf.DXFHatchPattern;
import org.kabeja.dxf.helpers.HatchBoundaryLoop;
import org.kabeja.dxf.helpers.HatchLineFamily;
import org.kabeja.dxf.helpers.HatchLineIterator;
import org.kabeja.dxf.helpers.HatchLineSegment;
import org.kabeja.dxf.helpers.Point;
import org.kabeja.math.TransformContext;
import org.kabeja.svg.SVGContext;
import org.kabeja.svg.SVGPathBoundaryGenerator;
import org.kabeja.svg.SVGSAXGeneratorManager;
import org.kabeja.svg.SVGUtils;
import org.kabeja.svg.generators.AbstractSVGSAXGenerator;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class SVGHatchGenerator
extends AbstractSVGSAXGenerator {
    public void toSAX(ContentHandler handler, Map svgContext, DXFEntity entity, TransformContext transformContext) throws SAXException {
        DXFHatch hatch = (DXFHatch)entity;
        SVGSAXGeneratorManager manager = (SVGSAXGeneratorManager)svgContext.get(SVGContext.SVGSAXGENERATOR_MANAGER);
        Bounds hatchBounds = hatch.getBounds();
        if (hatchBounds.isValid()) {
            AttributesImpl attr = new AttributesImpl();
            if (hatch.isSolid()) {
                super.setCommonAttributes(attr, svgContext, (DXFEntity)hatch);
                SVGUtils.addAttribute(attr, "fill", "currentColor");
                SVGUtils.startElement(handler, "g", attr);
                Iterator i = hatch.getBoundaryLoops();
                while (i.hasNext()) {
                    HatchBoundaryLoop loop = (HatchBoundaryLoop)i.next();
                    this.loopToSVGPath(handler, loop, manager);
                }
                SVGUtils.endElement(handler, "g");
            } else {
                attr = new AttributesImpl();
                SVGUtils.addAttribute(attr, "id", SVGUtils.validateID(hatch.getID()));
                boolean clipClipPath = false;
                if (hatch.getHatchStyle() < 2) {
                    this.islandToClipPath(handler, hatch, manager);
                    clipClipPath = true;
                    SVGUtils.addAttribute(attr, "clip-path", "url(#" + SVGUtils.validateID(hatch.getID()) + "_clip)");
                }
                SVGUtils.startElement(handler, "clipPath", attr);
                if (clipClipPath) {
                    this.outermostToSVGPath(handler, hatch, manager);
                } else {
                    Iterator i = hatch.getBoundaryLoops();
                    while (i.hasNext()) {
                        HatchBoundaryLoop loop = (HatchBoundaryLoop)i.next();
                        this.loopToSVGPath(handler, loop, manager);
                    }
                }
                SVGUtils.endElement(handler, "clipPath");
                DXFHatchPattern pattern = hatch.getDXFDocument().getDXFHatchPattern(hatch.getDXFHatchPatternID());
                attr = new AttributesImpl();
                SVGUtils.addAttribute(attr, "clip-path", "url(#" + SVGUtils.validateID(hatch.getID()) + ")");
                SVGUtils.startElement(handler, "g", attr);
                SVGUtils.startElement(handler, "title", new AttributesImpl());
                SVGUtils.characters(handler, hatch.getName());
                SVGUtils.endElement(handler, "title");
                this.convertHatchPatternToSAX(handler, svgContext, hatchBounds, hatch, transformContext, pattern);
                SVGUtils.endElement(handler, "g");
            }
        }
    }

    protected void islandToClipPath(ContentHandler handler, DXFHatch hatch, SVGSAXGeneratorManager manager) throws SAXException {
        AttributesImpl attr = new AttributesImpl();
        SVGUtils.addAttribute(attr, "id", SVGUtils.validateID(hatch.getID() + "_clip"));
        SVGUtils.startElement(handler, "clipPath", attr);
        Iterator i = hatch.getBoundaryLoops();
        while (i.hasNext()) {
            HatchBoundaryLoop loop = (HatchBoundaryLoop)i.next();
            if (loop.isOutermost()) continue;
            this.loopToSVGPath(handler, loop, manager);
        }
        SVGUtils.endElement(handler, "clipPath");
    }

    protected void outermostToSVGPath(ContentHandler handler, DXFHatch hatch, SVGSAXGeneratorManager manager) throws SAXException {
        Iterator i = hatch.getBoundaryLoops();
        while (i.hasNext()) {
            HatchBoundaryLoop loop = (HatchBoundaryLoop)i.next();
            if (!loop.isOutermost()) continue;
            this.loopToSVGPath(handler, loop, manager);
        }
    }

    protected void loopToSVGPath(ContentHandler handler, HatchBoundaryLoop loop, SVGSAXGeneratorManager manager) throws SAXException {
        StringBuffer buf = new StringBuffer();
        Iterator i = loop.getBoundaryEdgesIterator();
        if (i.hasNext()) {
            DXFEntity entity = (DXFEntity)i.next();
            buf.append(' ');
            String d = manager.getSVGPathBoundaryGenerator(entity.getType()).getSVGPath(entity);
            if (d.length() == 0) {
                return;
            }
            buf.append(d);
            buf.append(' ');
            while (i.hasNext()) {
                entity = (DXFEntity)i.next();
                SVGPathBoundaryGenerator part = manager.getSVGPathBoundaryGenerator(entity.getType());
                buf.append(' ');
                d = this.removeStartPoint(part.getSVGPath(entity).trim());
                buf.append(d);
                buf.append(' ');
            }
            if (d.length() > 0) {
                AttributesImpl attr = new AttributesImpl();
                SVGUtils.addAttribute(attr, "d", buf.toString());
                SVGUtils.emptyElement(handler, "path", attr);
            }
        }
    }

    protected String removeStartPoint(String svgPath) {
        if (svgPath.length() > 0 && svgPath.charAt(0) == 'M') {
            boolean separator = false;
            int delemiterCount = 0;
            for (int i = 1; i < svgPath.length(); ++i) {
                char c = svgPath.charAt(i);
                if (Character.isWhitespace(c) || c == ',') {
                    separator = true;
                    continue;
                }
                if (separator && delemiterCount == 2) {
                    return svgPath.substring(i - 1);
                }
                if (!separator) continue;
                ++delemiterCount;
                separator = false;
            }
        }
        return svgPath;
    }

    public void convertHatchPatternToSAX(ContentHandler handler, Map context, Bounds hatchBounds, DXFHatch hatch, TransformContext transformContext, DXFHatchPattern p) throws SAXException {
        double dotLength = (hatchBounds.getWidth() + hatchBounds.getHeight()) / 2.0 * 0.002;
        AttributesImpl attr = new AttributesImpl();
        Iterator i = p.getLineFamilyIterator();
        while (i.hasNext()) {
            HatchLineFamily pattern = (HatchLineFamily)i.next();
            attr = new AttributesImpl();
            if (context.containsKey(SVGContext.LAYER_STROKE_WIDTH)) {
                Double lw = (Double)context.get(SVGContext.LAYER_STROKE_WIDTH);
                SVGUtils.addAttribute(attr, "stroke-width", SVGUtils.formatNumberAttribute(lw));
            }
            SVGUtils.addAttribute(attr, "d", this.convertPatternToSVGPath(hatchBounds, hatch, pattern, dotLength));
            SVGUtils.emptyElement(handler, "path", attr);
        }
    }

    protected String convertPatternToSVGPath(Bounds b, DXFHatch hatch, HatchLineFamily pattern, double dotlength) {
        StringBuffer buf = new StringBuffer();
        HatchLineIterator li = new HatchLineIterator(hatch, pattern);
        while (li.hasNext()) {
            HatchLineSegment segment = (HatchLineSegment)li.next();
            Point startPoint = segment.getStartPoint();
            double x = startPoint.getX();
            double y = startPoint.getY();
            buf.append('M');
            buf.append(' ');
            buf.append(SVGUtils.formatNumberAttribute(x));
            buf.append(' ');
            buf.append(SVGUtils.formatNumberAttribute(y));
            buf.append(' ');
            if (segment.isSolid()) {
                Point p = segment.getPointAt(segment.getLength());
                buf.append('L');
                buf.append(' ');
                buf.append(SVGUtils.formatNumberAttribute(p.getX()));
                buf.append(' ');
                buf.append(SVGUtils.formatNumberAttribute(p.getY()));
                buf.append(' ');
                continue;
            }
            double length = 0.0;
            while (segment.hasNext()) {
                double l = segment.next();
                Point p = segment.getPointAt(length += Math.abs(l));
                if (l > 0.0) {
                    buf.append('L');
                    buf.append(' ');
                    buf.append(SVGUtils.formatNumberAttribute(p.getX()));
                    buf.append(' ');
                    buf.append(SVGUtils.formatNumberAttribute(p.getY()));
                    buf.append(' ');
                    continue;
                }
                if (l < 0.0) {
                    buf.append('M');
                    buf.append(' ');
                    buf.append(SVGUtils.formatNumberAttribute(p.getX()));
                    buf.append(' ');
                    buf.append(SVGUtils.formatNumberAttribute(p.getY()));
                    buf.append(' ');
                    continue;
                }
                buf.append('l');
                buf.append(' ');
                buf.append(SVGUtils.formatNumberAttribute(dotlength));
                buf.append(' ');
                buf.append(SVGUtils.formatNumberAttribute(dotlength));
                buf.append(' ');
            }
        }
        return buf.toString();
    }
}

