/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.svg.generators;

import java.util.Map;
import org.kabeja.dxf.DXFEntity;
import org.kabeja.dxf.DXFLine;
import org.kabeja.dxf.helpers.Point;
import org.kabeja.math.TransformContext;
import org.kabeja.svg.SVGPathBoundaryGenerator;
import org.kabeja.svg.SVGUtils;
import org.kabeja.svg.generators.AbstractSVGSAXGenerator;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class SVGLineGenerator
extends AbstractSVGSAXGenerator
implements SVGPathBoundaryGenerator {
    public void toSAX(ContentHandler handler, Map svgContext, DXFEntity entity, TransformContext transformContext) throws SAXException {
        DXFLine line = (DXFLine)entity;
        AttributesImpl attr = new AttributesImpl();
        SVGUtils.addAttribute(attr, "x1", SVGUtils.formatNumberAttribute(line.getStartPoint().getX()));
        SVGUtils.addAttribute(attr, "y1", SVGUtils.formatNumberAttribute(line.getStartPoint().getY()));
        SVGUtils.addAttribute(attr, "x2", SVGUtils.formatNumberAttribute(line.getEndPoint().getX()));
        SVGUtils.addAttribute(attr, "y2", SVGUtils.formatNumberAttribute(line.getEndPoint().getY()));
        super.setCommonAttributes(attr, svgContext, (DXFEntity)line);
        SVGUtils.emptyElement(handler, "line", attr);
    }

    public String getSVGPath(DXFEntity entity) {
        DXFLine line = (DXFLine)entity;
        Point start = line.getStartPoint();
        Point end = line.getEndPoint();
        StringBuffer buf = new StringBuffer();
        buf.append("M ");
        buf.append(SVGUtils.formatNumberAttribute(start.getX()));
        buf.append(" ");
        buf.append(SVGUtils.formatNumberAttribute(start.getY()));
        buf.append(" L ");
        buf.append(SVGUtils.formatNumberAttribute(end.getX()));
        buf.append(" ");
        buf.append(SVGUtils.formatNumberAttribute(end.getY()));
        return buf.toString();
    }
}

