/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.svg.generators;

import java.util.Map;
import org.kabeja.dxf.Bounds;
import org.kabeja.dxf.DXFEntity;
import org.kabeja.dxf.DXFStyle;
import org.kabeja.dxf.DXFText;
import org.kabeja.dxf.helpers.Point;
import org.kabeja.math.TransformContext;
import org.kabeja.svg.SVGContext;
import org.kabeja.svg.SVGUtils;
import org.kabeja.svg.generators.AbstractSVGSAXGenerator;
import org.kabeja.tools.FontManager;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class SVGTextGenerator
extends AbstractSVGSAXGenerator {
    public void toSAX(ContentHandler handler, Map svgContext, DXFEntity entity, TransformContext transformContext) throws SAXException {
        DXFText text = (DXFText)entity;
        AttributesImpl attr = new AttributesImpl();
        Point alignmentPoint = text.calculateAlignmentPoint();
        double height = text.getHeight();
        if (height == 0.0) {
            height = ((Bounds)svgContext.get(SVGContext.DRAFT_BOUNDS)).getHeight() * 0.005;
        }
        SVGUtils.addAttribute(attr, "font-size", SVGUtils.formatNumberAttribute(height));
        if (text.getDXFDocument().getDXFStyle(text.getTextStyle()) != null) {
            DXFStyle style = text.getDXFDocument().getDXFStyle(text.getTextStyle());
            FontManager manager = FontManager.getInstance();
            String fontID = null;
            if (manager.hasFontDescription(style.getBigFontFile())) {
                fontID = style.getBigFontFile();
            } else if (manager.hasFontDescription(style.getFontFile())) {
                fontID = style.getFontFile();
            }
            if (fontID != null) {
                if ((fontID = fontID.toLowerCase()).endsWith(".shx")) {
                    fontID = fontID.substring(0, fontID.indexOf(".shx"));
                }
                SVGUtils.addAttribute(attr, "font-family", fontID);
            }
        }
        if (!text.isUpsideDown()) {
            switch (text.getAlign()) {
                case 0: {
                    SVGUtils.addAttribute(attr, "text-anchor", "start");
                    break;
                }
                case 1: {
                    SVGUtils.addAttribute(attr, "text-anchor", "middle");
                    break;
                }
                case 2: {
                    SVGUtils.addAttribute(attr, "text-anchor", "end");
                    break;
                }
                case 3: {
                    SVGUtils.addAttribute(attr, "text-anchor", "end");
                    break;
                }
                case 4: {
                    SVGUtils.addAttribute(attr, "text-anchor", "middle");
                    break;
                }
                case 5: {
                    SVGUtils.addAttribute(attr, "text-anchor", "end");
                    break;
                }
                default: {
                    SVGUtils.addAttribute(attr, "text-anchor", "start");
                }
            }
        }
        StringBuffer transform = new StringBuffer();
        if (!text.isBackward()) {
            SVGUtils.addAttribute(attr, "writing-mode", "lr-tb");
        } else {
            transform.append("matrix(-1 0 0 1  ");
            transform.append(2.0 * alignmentPoint.getX());
            transform.append(" 0)");
        }
        if (!text.isUpsideDown()) {
            transform.append("matrix(1 0 0 -1 0 ");
            transform.append(2.0 * alignmentPoint.getY());
            transform.append(')');
        }
        if (text.getRotation() != 0.0) {
            transform.append(" rotate(");
            transform.append(-1.0 * text.getRotation());
            transform.append(' ');
            transform.append(alignmentPoint.getX());
            transform.append(' ');
            transform.append(alignmentPoint.getY());
            transform.append(' ');
            transform.append(')');
        }
        if (text.getObliqueAngle() != 0.0) {
            transform.append(" skewX(");
            transform.append(-1.0 * text.getObliqueAngle());
            transform.append(" )");
            transform.append(" translate( ");
            transform.append(alignmentPoint.getY() * Math.tan(Math.toRadians(1.0 * text.getObliqueAngle())));
            transform.append(')');
        }
        SVGUtils.addAttribute(attr, "transform", transform.toString());
        SVGUtils.addAttribute(attr, "x", "" + alignmentPoint.getX());
        SVGUtils.addAttribute(attr, "y", "" + alignmentPoint.getY());
        SVGUtils.addAttribute(attr, "fill", "currentColor");
        super.setCommonAttributes(attr, svgContext, (DXFEntity)text);
        SVGUtils.startElement(handler, "text", attr);
        SVGUtils.textDocumentToSAX(handler, text.getTextDocument());
        SVGUtils.endElement(handler, "text");
    }
}

