/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.svg.generators;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.kabeja.dxf.Bounds;
import org.kabeja.dxf.DXFColor;
import org.kabeja.dxf.DXFEntity;
import org.kabeja.dxf.DXFLayer;
import org.kabeja.dxf.DXFLineType;
import org.kabeja.dxf.DXFViewport;
import org.kabeja.dxf.helpers.Point;
import org.kabeja.math.TransformContext;
import org.kabeja.svg.SVGContext;
import org.kabeja.svg.SVGGenerationException;
import org.kabeja.svg.SVGSAXGenerator;
import org.kabeja.svg.SVGSAXGeneratorManager;
import org.kabeja.svg.SVGUtils;
import org.kabeja.svg.generators.AbstractSVGSAXGenerator;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class SVGViewportGenerator
extends AbstractSVGSAXGenerator {
    private SVGSAXGeneratorManager manager;

    public void toSAX(ContentHandler handler, Map svgContext, DXFEntity entity, TransformContext transformContext) throws SAXException {
        DXFViewport viewport = (DXFViewport)entity;
        svgContext = new HashMap<String, Double>(svgContext);
        if (viewport.getViewportStatus() > 0) {
            Point center = viewport.getCenterPoint();
            AttributesImpl attr = new AttributesImpl();
            SVGUtils.addAttribute(attr, "x", "" + SVGUtils.formatNumberAttribute(center.getX() - viewport.getWidth() / 2.0));
            SVGUtils.addAttribute(attr, "y", "" + SVGUtils.formatNumberAttribute(center.getY() - viewport.getHeight() / 2.0));
            SVGUtils.addAttribute(attr, "width", "" + SVGUtils.formatNumberAttribute(viewport.getWidth()));
            SVGUtils.addAttribute(attr, "height", "" + SVGUtils.formatNumberAttribute(viewport.getHeight()));
            super.setCommonAttributes(attr, svgContext, entity);
            SVGUtils.emptyElement(handler, "rect", attr);
            if (!viewport.isModelSpace() && !viewport.getViewportID().equals("1")) {
                attr = new AttributesImpl();
                SVGUtils.addAttribute(attr, "id", SVGUtils.validateID(viewport.getID() + "_clip"));
                SVGUtils.startElement(handler, "clipPath", attr);
                Bounds viewBounds = viewport.getModelspaceViewBounds();
                attr = new AttributesImpl();
                double w = viewBounds.getWidth() / 2.0;
                double h = viewBounds.getHeight() / 2.0;
                Point p = viewport.getViewCenterPoint();
                StringBuffer buf = new StringBuffer();
                buf.append('M');
                buf.append(' ');
                buf.append(SVGUtils.formatNumberAttribute(p.getX() - w));
                buf.append(' ');
                buf.append(SVGUtils.formatNumberAttribute(p.getY() - h));
                buf.append(' ');
                buf.append('L');
                buf.append(' ');
                buf.append(SVGUtils.formatNumberAttribute(p.getX() + w));
                buf.append(' ');
                buf.append(SVGUtils.formatNumberAttribute(p.getY() - h));
                buf.append(' ');
                buf.append('L');
                buf.append(' ');
                buf.append(SVGUtils.formatNumberAttribute(p.getX() + w));
                buf.append(' ');
                buf.append(SVGUtils.formatNumberAttribute(p.getY() + h));
                buf.append(' ');
                buf.append('L');
                buf.append(' ');
                buf.append(SVGUtils.formatNumberAttribute(p.getX() - w));
                buf.append(' ');
                buf.append(SVGUtils.formatNumberAttribute(p.getY() + h));
                buf.append(' ');
                buf.append('z');
                SVGUtils.addAttribute(attr, "viewBox", buf.toString());
                SVGUtils.addAttribute(attr, "d", buf.toString());
                SVGUtils.emptyElement(handler, "path", attr);
                SVGUtils.endElement(handler, "clipPath");
                double zoomXP = viewport.getZoomXPFactor();
                this.manager = (SVGSAXGeneratorManager)svgContext.get(SVGContext.SVGSAXGENERATOR_MANAGER);
                attr = new AttributesImpl();
                SVGUtils.addAttribute(attr, "id", viewport.getID());
                StringBuffer buff = new StringBuffer();
                buff.append("translate(");
                buff.append(' ');
                buff.append(viewport.getCenterPoint().getX());
                buff.append(' ');
                buff.append(viewport.getCenterPoint().getY());
                buff.append(')');
                buff.append("scale(");
                buff.append(zoomXP);
                buff.append(' ');
                buff.append(zoomXP);
                buff.append(')');
                buff.append(' ');
                buff.append("translate(");
                buff.append(' ');
                buff.append(-1.0 * viewport.getViewCenterPoint().getX());
                buff.append(' ');
                buff.append(-1.0 * viewport.getViewCenterPoint().getY());
                buff.append(')');
                SVGUtils.addAttribute(attr, "transform", buff.toString());
                double width = 0.0;
                if (svgContext.containsKey(SVGContext.STROKE_WIDTH)) {
                    Double lw = (Double)svgContext.get(SVGContext.LAYER_STROKE_WIDTH);
                    width = lw / zoomXP;
                } else {
                    double defaultSW;
                    width = (viewBounds.getWidth() + viewBounds.getHeight()) / 2.0 * 2.5E-4;
                    if (width > (defaultSW = 0.25)) {
                        width = defaultSW;
                    }
                }
                SVGUtils.addAttribute(attr, "stroke-width", SVGUtils.formatNumberAttribute(width));
                svgContext.put(SVGContext.STROKE_WIDTH, new Double(width));
                SVGUtils.addAttribute(attr, "clip-path", "url(#" + SVGUtils.validateID(viewport.getID() + "_clip") + ")");
                SVGUtils.startElement(handler, "g", attr);
                Iterator i = viewport.getDXFDocument().getDXFLayerIterator();
                while (i.hasNext()) {
                    DXFLayer layer = (DXFLayer)i.next();
                    if (viewport.isFrozenLayer(layer.getName())) continue;
                    this.layerToSAX(handler, layer, svgContext, viewBounds, viewport);
                }
                SVGUtils.endElement(handler, "g");
            }
        }
    }

    protected void layerToSAX(ContentHandler handler, DXFLayer layer, Map context, Bounds viewBounds, DXFViewport viewport) throws SAXException {
        String lt;
        AttributesImpl attr = new AttributesImpl();
        SVGUtils.addAttribute(attr, "id", SVGUtils.validateID(layer.getName()));
        SVGUtils.addAttribute(attr, "color", "rgb(" + DXFColor.getRGBString((int)Math.abs(layer.getColor())) + ")");
        SVGUtils.addAttribute(attr, "stroke", "currentColor");
        SVGUtils.addAttribute(attr, "fill", "none");
        if (!layer.isVisible()) {
            SVGUtils.addAttribute(attr, "visibility", "hidden");
        }
        if ((lt = layer.getLineType()).length() > 0) {
            DXFLineType ltype = layer.getDXFDocument().getDXFLineType(lt);
            SVGUtils.addStrokeDashArrayAttribute(attr, ltype);
        }
        int lineWeight = layer.getLineWeight();
        Double lw = null;
        if (lineWeight > 0 && !context.containsKey(SVGContext.STROKE_WIDTH_IGNORE)) {
            lw = new Double(lineWeight);
            SVGUtils.addAttribute(attr, "stroke-width", SVGUtils.lineWeightToStrokeWidth(lineWeight));
        } else {
            lw = (Double)context.get(SVGContext.STROKE_WIDTH);
            SVGUtils.addAttribute(attr, "stroke-width", SVGUtils.formatNumberAttribute(lw));
        }
        context.put(SVGContext.LAYER_STROKE_WIDTH, lw);
        SVGUtils.startElement(handler, "g", attr);
        Iterator types = layer.getDXFEntityTypeIterator();
        while (types.hasNext()) {
            String type = (String)types.next();
            ArrayList list = (ArrayList)layer.getDXFEntities(type);
            Iterator i = list.iterator();
            try {
                SVGSAXGenerator gen = this.manager.getSVGGenerator(type);
                while (i.hasNext()) {
                    DXFEntity entity = (DXFEntity)i.next();
                    Bounds b = entity.getBounds();
                    if (!entity.isModelSpace() || !b.contains(viewBounds)) continue;
                    gen.toSAX(handler, context, entity, null);
                }
            }
            catch (SVGGenerationException e) {
                e.printStackTrace();
            }
        }
        SVGUtils.endElement(handler, "g");
    }
}

