/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.lang.ref.SoftReference;
import org.apache.batik.bridge.AnimatableSVGBridge;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.BridgeUpdateHandler;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.ErrorConstants;
import org.apache.batik.bridge.GenericBridge;
import org.apache.batik.bridge.GraphicsNodeBridge;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.bridge.UnitProcessor;
import org.apache.batik.css.engine.CSSEngineEvent;
import org.apache.batik.css.engine.SVGCSSEngine;
import org.apache.batik.dom.events.AbstractEvent;
import org.apache.batik.dom.svg.AnimatedLiveAttributeValue;
import org.apache.batik.dom.svg.LiveAttributeException;
import org.apache.batik.dom.svg.SVGContext;
import org.apache.batik.dom.svg.SVGMotionAnimatableElement;
import org.apache.batik.dom.svg.SVGOMElement;
import org.apache.batik.ext.awt.geom.SegmentList;
import org.apache.batik.gvt.CanvasGraphicsNode;
import org.apache.batik.gvt.CompositeGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.parser.UnitProcessor;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.DocumentEvent;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.events.MutationEvent;
import org.w3c.dom.svg.SVGFitToViewBox;
import org.w3c.dom.svg.SVGTransformList;
import org.w3c.dom.svg.SVGTransformable;

public abstract class AbstractGraphicsNodeBridge
extends AnimatableSVGBridge
implements SVGContext,
BridgeUpdateHandler,
GraphicsNodeBridge,
ErrorConstants {
    protected GraphicsNode node;
    protected boolean isSVG12;
    protected UnitProcessor.Context unitContext;
    protected SoftReference bboxShape = null;
    protected Rectangle2D bbox = null;

    protected AbstractGraphicsNodeBridge() {
    }

    public GraphicsNode createGraphicsNode(BridgeContext bridgeContext, Element element) {
        if (!SVGUtilities.matchUserAgent(element, bridgeContext.getUserAgent())) {
            return null;
        }
        GraphicsNode graphicsNode = this.instantiateGraphicsNode();
        this.setTransform(graphicsNode, element);
        graphicsNode.setVisible(CSSUtilities.convertVisibility(element));
        this.associateSVGContext(bridgeContext, element, graphicsNode);
        return graphicsNode;
    }

    protected abstract GraphicsNode instantiateGraphicsNode();

    public void buildGraphicsNode(BridgeContext bridgeContext, Element element, GraphicsNode graphicsNode) {
        graphicsNode.setComposite(CSSUtilities.convertOpacity(element));
        graphicsNode.setFilter(CSSUtilities.convertFilter(element, graphicsNode, bridgeContext));
        graphicsNode.setMask(CSSUtilities.convertMask(element, graphicsNode, bridgeContext));
        graphicsNode.setClip(CSSUtilities.convertClipPath(element, graphicsNode, bridgeContext));
        graphicsNode.setPointerEventType(CSSUtilities.convertPointerEvents(element));
        this.initializeDynamicSupport(bridgeContext, element, graphicsNode);
    }

    public boolean getDisplay(Element element) {
        return CSSUtilities.convertDisplay(element);
    }

    protected void setTransform(GraphicsNode graphicsNode, Element element) {
        SVGTransformable sVGTransformable = (SVGTransformable)element;
        try {
            SVGMotionAnimatableElement sVGMotionAnimatableElement;
            Object object;
            AffineTransform affineTransform = new AffineTransform();
            SVGTransformList sVGTransformList = sVGTransformable.getTransform().getAnimVal();
            int n = sVGTransformList.getNumberOfItems();
            for (int i = 0; i < n; ++i) {
                object = sVGTransformList.getItem(i).getMatrix();
                affineTransform.concatenate(new AffineTransform(object.getA(), object.getB(), object.getC(), object.getD(), object.getE(), object.getF()));
            }
            if (element instanceof SVGMotionAnimatableElement && (object = (sVGMotionAnimatableElement = (SVGMotionAnimatableElement)((Object)element)).getMotionTransform()) != null) {
                affineTransform.concatenate((AffineTransform)object);
            }
            graphicsNode.setTransform(affineTransform);
        }
        catch (LiveAttributeException liveAttributeException) {
            throw new BridgeException(this.ctx, liveAttributeException);
        }
    }

    protected void associateSVGContext(BridgeContext bridgeContext, Element element, GraphicsNode graphicsNode) {
        this.e = element;
        this.node = graphicsNode;
        this.ctx = bridgeContext;
        this.unitContext = UnitProcessor.createContext(bridgeContext, element);
        this.isSVG12 = bridgeContext.isSVG12();
        ((SVGOMElement)element).setSVGContext(this);
    }

    protected void initializeDynamicSupport(BridgeContext bridgeContext, Element element, GraphicsNode graphicsNode) {
        if (bridgeContext.isInteractive()) {
            bridgeContext.bind(element, graphicsNode);
        }
    }

    public void handleDOMAttrModifiedEvent(MutationEvent mutationEvent) {
    }

    protected void handleGeometryChanged() {
        this.node.setFilter(CSSUtilities.convertFilter(this.e, this.node, this.ctx));
        this.node.setMask(CSSUtilities.convertMask(this.e, this.node, this.ctx));
        this.node.setClip(CSSUtilities.convertClipPath(this.e, this.node, this.ctx));
        if (this.isSVG12) {
            if (!"use".equals(this.e.getLocalName())) {
                this.fireShapeChangeEvent();
            }
            this.fireBBoxChangeEvent();
        }
    }

    protected void fireShapeChangeEvent() {
        DocumentEvent documentEvent = (DocumentEvent)((Object)this.e.getOwnerDocument());
        AbstractEvent abstractEvent = (AbstractEvent)documentEvent.createEvent("SVGEvents");
        abstractEvent.initEventNS("http://www.w3.org/2000/svg", "shapechange", true, false);
        try {
            ((EventTarget)((Object)this.e)).dispatchEvent(abstractEvent);
        }
        catch (RuntimeException runtimeException) {
            this.ctx.getUserAgent().displayError(runtimeException);
        }
    }

    public void handleDOMNodeInsertedEvent(MutationEvent mutationEvent) {
        Element element;
        Bridge bridge;
        if (mutationEvent.getTarget() instanceof Element && (bridge = this.ctx.getBridge(element = (Element)((Object)mutationEvent.getTarget()))) instanceof GenericBridge) {
            ((GenericBridge)bridge).handleElement(this.ctx, element);
        }
    }

    public void handleDOMNodeRemovedEvent(MutationEvent mutationEvent) {
        CompositeGraphicsNode compositeGraphicsNode = this.node.getParent();
        compositeGraphicsNode.remove(this.node);
        this.disposeTree(this.e);
    }

    public void handleDOMCharacterDataModified(MutationEvent mutationEvent) {
    }

    public void dispose() {
        SVGOMElement sVGOMElement = (SVGOMElement)this.e;
        sVGOMElement.setSVGContext(null);
        this.ctx.unbind(this.e);
    }

    protected void disposeTree(Node node) {
        this.disposeTree(node, true);
    }

    protected void disposeTree(Node node, boolean bl) {
        Node node2;
        SVGContext sVGContext;
        if (node instanceof SVGOMElement && (sVGContext = ((SVGOMElement)(node2 = (SVGOMElement)node)).getSVGContext()) instanceof BridgeUpdateHandler) {
            BridgeUpdateHandler bridgeUpdateHandler = (BridgeUpdateHandler)((Object)sVGContext);
            if (bl) {
                ((SVGOMElement)node2).setSVGContext(null);
            }
            bridgeUpdateHandler.dispose();
        }
        for (node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            this.disposeTree(node2, bl);
        }
    }

    public void handleCSSEngineEvent(CSSEngineEvent cSSEngineEvent) {
        try {
            SVGCSSEngine sVGCSSEngine = (SVGCSSEngine)cSSEngineEvent.getSource();
            int[] nArray = cSSEngineEvent.getProperties();
            for (int i = 0; i < nArray.length; ++i) {
                int n = nArray[i];
                this.handleCSSPropertyChanged(n);
                String string = sVGCSSEngine.getPropertyName(n);
                this.fireBaseAttributeListeners(string);
            }
        }
        catch (Exception exception) {
            this.ctx.getUserAgent().displayError(exception);
        }
    }

    protected void handleCSSPropertyChanged(int n) {
        switch (n) {
            case 57: {
                this.node.setVisible(CSSUtilities.convertVisibility(this.e));
                break;
            }
            case 38: {
                this.node.setComposite(CSSUtilities.convertOpacity(this.e));
                break;
            }
            case 18: {
                this.node.setFilter(CSSUtilities.convertFilter(this.e, this.node, this.ctx));
                break;
            }
            case 37: {
                this.node.setMask(CSSUtilities.convertMask(this.e, this.node, this.ctx));
                break;
            }
            case 3: {
                this.node.setClip(CSSUtilities.convertClipPath(this.e, this.node, this.ctx));
                break;
            }
            case 40: {
                this.node.setPointerEventType(CSSUtilities.convertPointerEvents(this.e));
                break;
            }
            case 12: {
                if (this.getDisplay(this.e)) break;
                CompositeGraphicsNode compositeGraphicsNode = this.node.getParent();
                compositeGraphicsNode.remove(this.node);
                this.disposeTree(this.e, false);
            }
        }
    }

    public void handleAnimatedAttributeChanged(AnimatedLiveAttributeValue animatedLiveAttributeValue) {
        if (animatedLiveAttributeValue.getNamespaceURI() == null && animatedLiveAttributeValue.getLocalName().equals("transform")) {
            this.setTransform(this.node, this.e);
            this.handleGeometryChanged();
        }
    }

    public void handleOtherAnimationChanged(String string) {
        if (string.equals("motion")) {
            this.setTransform(this.node, this.e);
            this.handleGeometryChanged();
        }
    }

    protected void checkBBoxChange() {
        if (this.e != null) {
            this.fireBBoxChangeEvent();
        }
    }

    protected void fireBBoxChangeEvent() {
        DocumentEvent documentEvent = (DocumentEvent)((Object)this.e.getOwnerDocument());
        AbstractEvent abstractEvent = (AbstractEvent)documentEvent.createEvent("SVGEvents");
        abstractEvent.initEventNS("http://www.w3.org/2000/svg", "RenderedBBoxChange", true, false);
        try {
            ((EventTarget)((Object)this.e)).dispatchEvent(abstractEvent);
        }
        catch (RuntimeException runtimeException) {
            this.ctx.getUserAgent().displayError(runtimeException);
        }
    }

    public float getPixelUnitToMillimeter() {
        return this.ctx.getUserAgent().getPixelUnitToMillimeter();
    }

    public float getPixelToMM() {
        return this.getPixelUnitToMillimeter();
    }

    public Rectangle2D getBBox() {
        if (this.node == null) {
            return null;
        }
        Shape shape = this.node.getOutline();
        if (this.bboxShape != null && shape == this.bboxShape.get()) {
            return this.bbox;
        }
        this.bboxShape = new SoftReference<Shape>(shape);
        this.bbox = null;
        if (shape == null) {
            return this.bbox;
        }
        SegmentList segmentList = new SegmentList(shape);
        this.bbox = segmentList.getBounds2D();
        return this.bbox;
    }

    public AffineTransform getCTM() {
        GraphicsNode graphicsNode = this.node;
        AffineTransform affineTransform = new AffineTransform();
        Element element = this.e;
        while (element != null) {
            AffineTransform affineTransform2;
            if (element instanceof SVGFitToViewBox) {
                affineTransform2 = graphicsNode instanceof CanvasGraphicsNode ? ((CanvasGraphicsNode)graphicsNode).getViewingTransform() : graphicsNode.getTransform();
                if (affineTransform2 == null) break;
                affineTransform.preConcatenate(affineTransform2);
                break;
            }
            affineTransform2 = graphicsNode.getTransform();
            if (affineTransform2 != null) {
                affineTransform.preConcatenate(affineTransform2);
            }
            element = SVGCSSEngine.getParentCSSStylableElement(element);
            graphicsNode = graphicsNode.getParent();
        }
        return affineTransform;
    }

    public AffineTransform getScreenTransform() {
        return this.ctx.getUserAgent().getTransform();
    }

    public void setScreenTransform(AffineTransform affineTransform) {
        this.ctx.getUserAgent().setTransform(affineTransform);
    }

    public AffineTransform getGlobalTransform() {
        return this.node.getGlobalTransform();
    }

    public float getViewportWidth() {
        return this.ctx.getBlockWidth(this.e);
    }

    public float getViewportHeight() {
        return this.ctx.getBlockHeight(this.e);
    }

    public float getFontSize() {
        return CSSUtilities.getComputedStyle(this.e, 22).getFloatValue();
    }
}

