/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.util.ArrayList;
import org.apache.batik.anim.AbstractAnimation;
import org.apache.batik.anim.MotionAnimation;
import org.apache.batik.anim.values.AnimatableMotionPointValue;
import org.apache.batik.anim.values.AnimatableValue;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.SVGAnimateElementBridge;
import org.apache.batik.dom.anim.AnimationTarget;
import org.apache.batik.dom.svg.SVGAnimatedPathDataSupport;
import org.apache.batik.dom.svg.SVGOMElement;
import org.apache.batik.dom.svg.SVGOMPathElement;
import org.apache.batik.dom.util.XLinkSupport;
import org.apache.batik.ext.awt.geom.ExtendedGeneralPath;
import org.apache.batik.parser.AWTPathProducer;
import org.apache.batik.parser.AngleHandler;
import org.apache.batik.parser.AngleParser;
import org.apache.batik.parser.LengthArrayProducer;
import org.apache.batik.parser.LengthPairListParser;
import org.apache.batik.parser.ParseException;
import org.apache.batik.parser.PathParser;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SVGAnimateMotionElementBridge
extends SVGAnimateElementBridge {
    public String getLocalName() {
        return "animateMotion";
    }

    public Bridge getInstance() {
        return new SVGAnimateMotionElementBridge();
    }

    protected AbstractAnimation createAnimation(AnimationTarget animationTarget) {
        this.animationType = (short)2;
        this.attributeLocalName = "motion";
        AnimatableValue animatableValue = this.parseLengthPair("from");
        AnimatableValue animatableValue2 = this.parseLengthPair("to");
        AnimatableValue animatableValue3 = this.parseLengthPair("by");
        boolean bl = false;
        boolean bl2 = false;
        float f = 0.0f;
        short s = 0;
        String string = this.element.getAttributeNS(null, "rotate");
        if (string.length() != 0) {
            if (string.equals("auto")) {
                bl = true;
            } else if (string.equals("auto-reverse")) {
                bl = true;
                bl2 = true;
            } else {
                AngleParser angleParser = new AngleParser();
                class Handler
                implements AngleHandler {
                    float theAngle;
                    short theUnit = 1;

                    Handler() {
                    }

                    public void startAngle() throws ParseException {
                    }

                    public void angleValue(float f) throws ParseException {
                        this.theAngle = f;
                    }

                    public void deg() throws ParseException {
                        this.theUnit = (short)2;
                    }

                    public void grad() throws ParseException {
                        this.theUnit = (short)4;
                    }

                    public void rad() throws ParseException {
                        this.theUnit = (short)3;
                    }

                    public void endAngle() throws ParseException {
                    }
                }
                Handler handler = new Handler();
                angleParser.setAngleHandler(handler);
                try {
                    angleParser.parse(string);
                }
                catch (ParseException parseException) {
                    throw new BridgeException(this.ctx, this.element, "attribute.malformed", new Object[]{"rotate", string});
                }
                f = handler.theAngle;
                s = handler.theUnit;
            }
        }
        return new MotionAnimation(this.timedElement, this, this.parseCalcMode(), this.parseKeyTimes(), this.parseKeySplines(), this.parseAdditive(), this.parseAccumulate(), this.parseValues(), animatableValue, animatableValue2, animatableValue3, this.parsePath(), this.parseKeyPoints(), bl, bl2, f, s);
    }

    protected ExtendedGeneralPath parsePath() {
        for (Node node = this.element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1 || !"http://www.w3.org/2000/svg".equals(node.getNamespaceURI()) || !"mpath".equals(node.getLocalName())) continue;
            String string = XLinkSupport.getXLinkHref((Element)node);
            Element element = this.ctx.getReferencedElement(this.element, string);
            if (!"http://www.w3.org/2000/svg".equals(element.getNamespaceURI()) || !"path".equals(element.getLocalName())) {
                throw new BridgeException(this.ctx, this.element, "uri.badTarget", new Object[]{string});
            }
            SVGOMPathElement sVGOMPathElement = (SVGOMPathElement)element;
            AWTPathProducer aWTPathProducer = new AWTPathProducer();
            SVGAnimatedPathDataSupport.handlePathSegList(sVGOMPathElement.getPathSegList(), aWTPathProducer);
            return (ExtendedGeneralPath)aWTPathProducer.getShape();
        }
        String string = this.element.getAttributeNS(null, "path");
        if (string.length() == 0) {
            return null;
        }
        try {
            AWTPathProducer aWTPathProducer = new AWTPathProducer();
            PathParser pathParser = new PathParser();
            pathParser.setPathHandler(aWTPathProducer);
            pathParser.parse(string);
            return (ExtendedGeneralPath)aWTPathProducer.getShape();
        }
        catch (ParseException parseException) {
            throw new BridgeException(this.ctx, this.element, "attribute.malformed", new Object[]{"path", string});
        }
    }

    protected float[] parseKeyPoints() {
        String string = this.element.getAttributeNS(null, "keyPoints");
        int n = string.length();
        if (n == 0) {
            return null;
        }
        ArrayList<Float> arrayList = new ArrayList<Float>(7);
        int n2 = 0;
        int n3 = 0;
        block2: while (n2 < n) {
            while (string.charAt(n2) == ' ') {
                if (++n2 != n) continue;
                break block2;
            }
            n3 = n2++;
            if (n2 != n) {
                char c = string.charAt(n2);
                while (c != ' ' && c != ';' && c != ',' && ++n2 != n) {
                    c = string.charAt(n2);
                }
            }
            int n4 = n2++;
            try {
                float f = Float.parseFloat(string.substring(n3, n4));
                arrayList.add(new Float(f));
            }
            catch (NumberFormatException numberFormatException) {
                throw new BridgeException(this.ctx, this.element, "attribute.malformed", new Object[]{"keyPoints", string});
            }
        }
        n = arrayList.size();
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            fArray[i] = ((Float)arrayList.get(i)).floatValue();
        }
        return fArray;
    }

    protected int getDefaultCalcMode() {
        return 2;
    }

    protected AnimatableValue[] parseValues() {
        String string = this.element.getAttributeNS(null, "values");
        int n = string.length();
        if (n == 0) {
            return null;
        }
        return this.parseValues(string);
    }

    protected AnimatableValue[] parseValues(String string) {
        try {
            LengthPairListParser lengthPairListParser = new LengthPairListParser();
            LengthArrayProducer lengthArrayProducer = new LengthArrayProducer();
            lengthPairListParser.setLengthListHandler(lengthArrayProducer);
            lengthPairListParser.parse(string);
            short[] sArray = lengthArrayProducer.getLengthTypeArray();
            float[] fArray = lengthArrayProducer.getLengthValueArray();
            AnimatableValue[] animatableValueArray = new AnimatableValue[sArray.length / 2];
            for (int i = 0; i < sArray.length; i += 2) {
                float f = this.animationTarget.svgToUserSpace(fArray[i], sArray[i], (short)1);
                float f2 = this.animationTarget.svgToUserSpace(fArray[i + 1], sArray[i + 1], (short)2);
                animatableValueArray[i / 2] = new AnimatableMotionPointValue(this.animationTarget, f, f2, 0.0f);
            }
            return animatableValueArray;
        }
        catch (ParseException parseException) {
            throw new BridgeException(this.ctx, this.element, "attribute.malformed", new Object[]{"values", string});
        }
    }

    protected AnimatableValue parseLengthPair(String string) {
        String string2 = this.element.getAttributeNS(null, string);
        if (string2.length() == 0) {
            return null;
        }
        return this.parseValues(string2)[0];
    }

    public AnimatableValue getUnderlyingValue() {
        return new AnimatableMotionPointValue(this.animationTarget, 0.0f, 0.0f, 0.0f);
    }

    protected void initializeAnimation() {
        Node node;
        String string = XLinkSupport.getXLinkHref(this.element);
        if (string.length() == 0) {
            node = this.element.getParentNode();
        } else {
            node = this.ctx.getReferencedElement(this.element, string);
            if (node.getOwnerDocument() != this.element.getOwnerDocument()) {
                throw new BridgeException(this.ctx, this.element, "uri.badTarget", new Object[]{string});
            }
        }
        this.animationTarget = null;
        if (node instanceof SVGOMElement) {
            this.targetElement = (SVGOMElement)node;
            this.animationTarget = this.targetElement;
        }
        if (this.animationTarget == null) {
            throw new BridgeException(this.ctx, this.element, "uri.badTarget", new Object[]{string});
        }
        this.timedElement = this.createTimedElement();
        this.animation = this.createAnimation(this.animationTarget);
        this.eng.addAnimation(this.animationTarget, (short)2, this.attributeNamespaceURI, this.attributeLocalName, this.animation);
    }
}

